/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIEnergyExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetEnergyExport
extends ProgWidgetInventoryBase {
    public static final MapCodec<ProgWidgetEnergyExport> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetEnergyExport.invParts(builder).apply((Applicative)builder, ProgWidgetEnergyExport::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetEnergyExport> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, ProgWidgetEnergyExport::new);

    public ProgWidgetEnergyExport() {
        this(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT);
    }

    public ProgWidgetEnergyExport(ProgWidget.PositionFields positionFields, ProgWidgetInventoryBase.InvBaseFields invBaseFields) {
        super(positionFields, invBaseFields);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetEnergyExport(this.getPosition(), this.invBaseFields().copy());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return List.of(ModProgWidgetTypes.AREA.get());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.RF_EXPORT.get();
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAIEnergyExport(drone, (ProgWidgetInventoryBase)widget);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_RF_EXPORT;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.ORANGE;
    }
}

