/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.drone.area.EnumOldAreaType;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetAreaTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class AreaTypeBox
extends AreaType {
    public static final MapCodec<AreaTypeBox> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)StringRepresentable.fromEnum(BoxType::values).optionalFieldOf("box_type", (Object)BoxType.FILLED).forGetter(AreaTypeBox::boxType)).apply((Applicative)builder, AreaTypeBox::new));
    public static final StreamCodec<FriendlyByteBuf, AreaTypeBox> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(BoxType.class), AreaTypeBox::boxType, AreaTypeBox::new);
    public static final String ID = "box";
    private BoxType boxType;

    public AreaTypeBox(BoxType boxType) {
        super(ID);
        this.boxType = boxType;
    }

    public AreaTypeBox() {
        this(BoxType.FILLED);
    }

    @Override
    public AreaType copy() {
        return new AreaTypeBox(this.boxType);
    }

    public BoxType boxType() {
        return this.boxType;
    }

    @Override
    public AreaTypeSerializer<? extends AreaType> getSerializer() {
        return ModProgWidgetAreaTypes.AREA_TYPE_BOX.get();
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.boxType.ordinal()) {
            case 0: {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = maxY; y >= minY; --y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            int axisRight = 0;
                            if (x == minX || x == maxX) {
                                ++axisRight;
                            }
                            if (y == minY || y == maxY) {
                                ++axisRight;
                            }
                            if (z == minZ || z == maxZ) {
                                ++axisRight;
                            }
                            if (axisRight <= 1) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.boxType.toString());
            }
        }
    }

    public String toString() {
        return this.getName() + "/" + String.valueOf(this.boxType);
    }

    @Override
    public void convertFromLegacy(EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case FILL: {
                this.boxType = BoxType.FILLED;
                break;
            }
            case WALL: {
                this.boxType = BoxType.HOLLOW;
                break;
            }
            case FRAME: {
                this.boxType = BoxType.FRAME;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaTypeWidget.EnumSelectorField<BoxType>("pneumaticcraft.gui.progWidget.area.type.box.boxType", BoxType.class, () -> this.boxType, boxType -> {
            this.boxType = boxType;
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaTypeBox that = (AreaTypeBox)o;
        return this.boxType == that.boxType;
    }

    public int hashCode() {
        return Objects.hashCode(this.boxType);
    }

    public static enum BoxType implements ITranslatableEnum,
    StringRepresentable
    {
        FILLED("filled"),
        HOLLOW("hollow"),
        FRAME("frame");

        private final String name;

        private BoxType(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.area.type.box.boxType." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

