/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.recipes.other.HeatPropertiesRecipeImpl;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public enum BlockHeatProperties implements Iterable<HeatPropertiesRecipe>
{
    INSTANCE;

    private final ArrayListMultimap<Block, HeatPropertiesRecipe> customHeatEntries = ArrayListMultimap.create();

    public static BlockHeatProperties getInstance() {
        return INSTANCE;
    }

    public HeatPropertiesRecipe getCustomHeatEntry(Level world, BlockState state) {
        if (this.customHeatEntries.isEmpty()) {
            this.populateCustomHeatEntries(world);
        }
        return this.customHeatEntries.get((Object)state.getBlock()).stream().filter(entry -> entry.matchState(state)).findFirst().orElse(null);
    }

    public Collection<HeatPropertiesRecipe> getAllEntries(Level world) {
        if (this.customHeatEntries.isEmpty()) {
            this.populateCustomHeatEntries(world);
        }
        return this.customHeatEntries.values();
    }

    public void clear() {
        this.customHeatEntries.clear();
    }

    public void register(Block block, HeatPropertiesRecipe entry) {
        this.customHeatEntries.put((Object)block, (Object)entry);
    }

    private void populateCustomHeatEntries(Level world) {
        ModRecipeTypes.getRecipes(world, ModRecipeTypes.BLOCK_HEAT_PROPERTIES).forEach(recipe -> this.customHeatEntries.put((Object)((HeatPropertiesRecipe)recipe.value()).getBlock(), (Object)((HeatPropertiesRecipe)recipe.value())));
        this.registerDefaultFluidValues();
    }

    private void registerDefaultFluidValues() {
        for (ResourceLocation fluidId : BuiltInRegistries.FLUID.keySet()) {
            List entry;
            Block block;
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidId);
            if (fluid == Fluids.EMPTY || !((Boolean)ConfigHelper.common().heat.addDefaultFluidEntries.get()).booleanValue() && !fluidId.getNamespace().equals("minecraft") || !((block = fluid.defaultFluidState().createLegacyBlock().getBlock()) instanceof LiquidBlock) || this.customHeatEntries.containsKey((Object)block) || !(entry = this.customHeatEntries.get((Object)block)).isEmpty()) continue;
            this.customHeatEntries.put((Object)block, (Object)this.buildDefaultFluidEntry(block, fluid));
        }
    }

    private HeatPropertiesRecipe buildDefaultFluidEntry(Block block, Fluid fluid) {
        BlockState transformColdFlowing;
        BlockState transformCold;
        BlockState transformHotFlowing;
        BlockState transformHot;
        int temperature = fluid.getFluidType().getTemperature();
        if (temperature >= Fluids.LAVA.getFluidType().getTemperature()) {
            transformHot = null;
            transformHotFlowing = null;
            transformCold = Blocks.OBSIDIAN.defaultBlockState();
            transformColdFlowing = Blocks.COBBLESTONE.defaultBlockState();
        } else if (temperature <= 273) {
            transformHot = Blocks.SNOW_BLOCK.defaultBlockState();
            transformHotFlowing = Blocks.SNOW.defaultBlockState();
            transformCold = Blocks.BLUE_ICE.defaultBlockState();
            transformColdFlowing = Blocks.SNOW.defaultBlockState();
        } else {
            transformHot = Blocks.AIR.defaultBlockState();
            transformHotFlowing = Blocks.AIR.defaultBlockState();
            transformCold = Blocks.ICE.defaultBlockState();
            transformColdFlowing = Blocks.SNOW.defaultBlockState();
        }
        return new HeatPropertiesRecipeImpl(block, new HeatPropertiesRecipe.Transforms(Optional.ofNullable(transformHot), Optional.of(transformCold), Optional.ofNullable(transformHotFlowing), Optional.of(transformColdFlowing)), Optional.of((Integer)ConfigHelper.common().heat.defaultFluidHeatCapacity.get()), temperature, Optional.of((Double)ConfigHelper.common().heat.fluidThermalResistance.get()), Collections.emptyMap(), "");
    }

    @Override
    public Iterator<HeatPropertiesRecipe> iterator() {
        return this.customHeatEntries.values().iterator();
    }
}

