/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSendNBTPacket;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ProgrammerMenu
extends AbstractPneumaticCraftMenu<ProgrammerBlockEntity> {
    public ProgrammerMenu(int i, Inventory playerInventory, BlockPos pos) {
        super(ModMenuTypes.PROGRAMMER.get(), i, playerInventory, pos);
        boolean isClient = playerInventory.player.level().isClientSide;
        AreaGeometry geometry = isClient ? ProgrammerScreen.calculateAreaBounds() : AreaGeometry.DUMMY;
        this.addSlot((Slot)new SlotItemHandler(this, ((ProgrammerBlockEntity)this.blockEntity).getItemHandler(), 0, geometry.x + geometry.width + 24, geometry.y - 8){

            public boolean mayPlace(@Nonnull ItemStack stack) {
                return IProgrammable.isProgrammable(stack);
            }
        });
        this.addPlayerSlots(playerInventory, geometry.x + geometry.width / 2 - 81, geometry.y + geometry.height + 6);
    }

    public ProgrammerMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(windowId, playerInventory, ProgrammerMenu.getTilePos(buffer));
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        if (((ProgrammerBlockEntity)this.blockEntity).nonNullLevel().getGameTime() % 20L == 0L) {
            for (Direction d : DirectionUtil.VALUES) {
                BlockEntity neighbor = ((ProgrammerBlockEntity)this.blockEntity).getCachedNeighbor(d);
                if (neighbor == null || !IOHelper.getInventoryForBlock(neighbor, d.getOpposite()).isPresent()) continue;
                ProgrammerMenu self = this;
                List<ServerPlayer> players = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers().stream().filter(p -> p.containerMenu == self).toList();
                if (players.isEmpty()) continue;
                players.forEach(p -> NetworkHandler.sendToPlayer(PacketSendNBTPacket.forBlockEntity(neighbor), p));
            }
        }
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player par1EntityPlayer, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot srcSlot = (Slot)this.slots.get(slotIndex);
        if (srcSlot != null && srcSlot.hasItem()) {
            ItemStack stackInSlot = srcSlot.getItem();
            stack = stackInSlot.copy();
            if (slotIndex == 0) {
                if (!this.moveItemStackTo(stackInSlot, 1, 36, false)) {
                    return ItemStack.EMPTY;
                }
                srcSlot.onQuickCraft(stackInSlot, stack);
            } else if (IProgrammable.isProgrammable(stack)) {
                if (!this.moveItemStackTo(stackInSlot, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
                srcSlot.onQuickCraft(stackInSlot, stack);
            }
            if (stackInSlot.isEmpty()) {
                srcSlot.set(ItemStack.EMPTY);
            } else {
                srcSlot.setChanged();
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            srcSlot.onTake(par1EntityPlayer, stackInSlot);
        }
        return stack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (playerIn.level().isClientSide) {
            ProgrammerScreen.onCloseFromContainer();
        }
    }

    public record AreaGeometry(int x, int y, int width, int height) {
        public static final AreaGeometry DUMMY = new AreaGeometry(5, 17, 100, 100);
    }
}

