/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.processing.UVLightBoxBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.slot.OutputOnlySlot;
import me.desht.pneumaticcraft.common.inventory.slot.UpgradeSlot;
import me.desht.pneumaticcraft.common.item.EmptyPCBItem;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class UVLightBoxMenu
extends AbstractPneumaticCraftMenu<UVLightBoxBlockEntity> {
    public UVLightBoxMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, UVLightBoxMenu.getTilePos(buffer));
    }

    public UVLightBoxMenu(int windowId, Inventory playerInventory, BlockPos pos) {
        super(ModMenuTypes.UV_LIGHT_BOX.get(), windowId, playerInventory, pos);
        this.addSlot((Slot)new SlotPCB(((UVLightBoxBlockEntity)this.blockEntity).getInputHandler(), 0, 11, 22));
        this.addSlot((Slot)new OutputOnlySlot(((UVLightBoxBlockEntity)this.blockEntity).getOutputHandler(), 0, 49, 22));
        for (int i = 0; i < 4; ++i) {
            this.addSlot((Slot)new UpgradeSlot(this.blockEntity, i, 98 + i * 18, 90));
        }
        this.addPlayerSlots(playerInventory, 114);
    }

    private static class SlotPCB
    extends SlotItemHandler {
        SlotPCB(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return stack.getItem() instanceof EmptyPCBItem && EmptyPCBItem.getEtchProgress(stack) == 0;
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

