/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory.slot;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class PlayerEquipmentSlot
extends Slot {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private final EquipmentSlot slotType;

    public PlayerEquipmentSlot(Inventory inventoryIn, EquipmentSlot slotType, int xPosition, int yPosition) {
        super((Container)inventoryIn, PlayerEquipmentSlot.getIndexForSlot(slotType), xPosition, yPosition);
        this.slotType = slotType;
    }

    public int getMaxStackSize() {
        return this.slotType == EquipmentSlot.OFFHAND ? super.getMaxStackSize() : 1;
    }

    public boolean mayPlace(ItemStack stack) {
        return this.slotType == EquipmentSlot.OFFHAND ? super.mayPlace(stack) : stack.canEquip(this.slotType, (LivingEntity)((Inventory)this.container).player);
    }

    public boolean mayPickup(Player playerIn) {
        if (this.slotType == EquipmentSlot.OFFHAND) {
            return super.mayPickup(playerIn);
        }
        ItemStack itemstack = this.getItem();
        return (itemstack.isEmpty() || playerIn.isCreative() || !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) && super.mayPickup(playerIn);
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return this.slotType.getType() == EquipmentSlot.Type.HUMANOID_ARMOR ? Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ARMOR_SLOT_TEXTURES[this.slotType.getIndex()]) : Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
    }

    private static int getIndexForSlot(EquipmentSlot type) {
        if (type.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
            return 36 + type.getIndex();
        }
        if (type == EquipmentSlot.OFFHAND) {
            return 40;
        }
        throw new IllegalArgumentException("invalid equipment slot: " + String.valueOf(type));
    }
}

