/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketServerTickTime(double tickTime) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketServerTickTime> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("server_tick_time"));
    public static final StreamCodec<FriendlyByteBuf, PacketServerTickTime> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, PacketServerTickTime::tickTime, PacketServerTickTime::new);
    private static double tickTimeMultiplier = 1.0;

    public CustomPacketPayload.Type<PacketServerTickTime> type() {
        return TYPE;
    }

    public static void handle(PacketServerTickTime message, IPayloadContext ignoredCtx) {
        tickTimeMultiplier = Math.min(1.0, 50.0 / Math.max(message.tickTime(), 0.01));
    }

    public static double getTickTimeMultiplier() {
        return tickTimeMultiplier;
    }
}

