/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector3f;

public record PacketSetEntityMotion(Vector3f vec, int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSetEntityMotion> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("set_entity_motion"));
    public static final StreamCodec<FriendlyByteBuf, PacketSetEntityMotion> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VECTOR3F, PacketSetEntityMotion::vec, (StreamCodec)ByteBufCodecs.INT, PacketSetEntityMotion::entityId, PacketSetEntityMotion::new);

    public static PacketSetEntityMotion create(Entity entity, Vec3 motion) {
        return new PacketSetEntityMotion(motion.toVector3f(), entity.getId());
    }

    public CustomPacketPayload.Type<PacketSetEntityMotion> type() {
        return TYPE;
    }

    public static void handle(PacketSetEntityMotion message, IPayloadContext ctx) {
        Entity entity = ctx.player().level().getEntity(message.entityId());
        if (entity != null) {
            entity.setDeltaMovement(new Vec3(message.vec()));
            entity.setOnGround(false);
            entity.horizontalCollision = false;
            entity.verticalCollision = false;
            if (entity instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)entity;
                l.setJumping(true);
            }
        }
    }
}

