/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Objects;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.RingEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector3f;

public record PacketSpawnRing(Vector3f vec, int targetEntityId, int color) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSpawnRing> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("spawn_ring"));
    public static final StreamCodec<FriendlyByteBuf, PacketSpawnRing> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VECTOR3F, PacketSpawnRing::vec, (StreamCodec)ByteBufCodecs.INT, PacketSpawnRing::targetEntityId, (StreamCodec)ByteBufCodecs.INT, PacketSpawnRing::color, PacketSpawnRing::new);

    public static PacketSpawnRing create(BlockPos pos, Entity targetEntity, Integer color) {
        return new PacketSpawnRing(Vec3.atCenterOf((Vec3i)pos).toVector3f(), targetEntity.getId(), Objects.requireNonNullElse(color, -1));
    }

    public CustomPacketPayload.Type<PacketSpawnRing> type() {
        return TYPE;
    }

    public static void handle(PacketSpawnRing message, IPayloadContext ctx) {
        Level level = ctx.player().level();
        Entity entity = level.getEntity(message.targetEntityId());
        if (entity != null) {
            Vector3f vec = message.vec();
            ClientUtils.spawnEntityClientside(new RingEntity(level, vec.x, vec.y, vec.z, entity, message.color()));
        }
    }
}

