/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public record PacketUpdatePressureBlock(BlockPos pos, Optional<Direction> handlerDir, Optional<Direction> leakDir, int currentAir) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUpdatePressureBlock> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("update_pressure_block"));
    public static final StreamCodec<FriendlyByteBuf, PacketUpdatePressureBlock> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketUpdatePressureBlock::pos, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Direction.STREAM_CODEC), PacketUpdatePressureBlock::handlerDir, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Direction.STREAM_CODEC), PacketUpdatePressureBlock::leakDir, (StreamCodec)ByteBufCodecs.INT, PacketUpdatePressureBlock::currentAir, PacketUpdatePressureBlock::new);

    public static PacketUpdatePressureBlock create(BlockPos pos, @Nullable Direction handlerDir, @Nullable Direction leakDir, int currentAir) {
        return new PacketUpdatePressureBlock(pos, Optional.ofNullable(handlerDir), Optional.ofNullable(leakDir), currentAir);
    }

    public CustomPacketPayload.Type<PacketUpdatePressureBlock> type() {
        return TYPE;
    }

    public static void handle(PacketUpdatePressureBlock message, IPayloadContext ctx) {
        BlockEntity blockEntity = ctx.player().level().getBlockEntity(message.pos());
        if (blockEntity != null) {
            Direction handlerDir = message.handlerDir().orElse(null);
            PNCCapabilities.getAirHandler(blockEntity, handlerDir).ifPresent(handler -> {
                handler.setSideLeaking(message.leakDir().orElse(null));
                handler.addAir(message.currentAir() - handler.getAir());
                if (handlerDir != null && blockEntity instanceof AbstractAirHandlingBlockEntity) {
                    AbstractAirHandlingBlockEntity aah = (AbstractAirHandlingBlockEntity)blockEntity;
                    aah.initializeHullAirHandlerClient(handlerDir, (IAirHandlerMachine)handler);
                }
            });
        }
    }
}

