/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;

public class ModCraftingHelper {
    public static List<ItemStack> findItems(CraftingInput inv, List<Predicate<ItemStack>> predicates) {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        BitSet matchedSlots = new BitSet(inv.size());
        for (Predicate<ItemStack> pred : predicates) {
            boolean found = false;
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack stack;
                if (matchedSlots.get(i) || !pred.test(stack = inv.getItem(i))) continue;
                res.add(stack);
                matchedSlots.set(i);
                found = true;
                break;
            }
            if (found) continue;
            return List.of();
        }
        for (int i = 0; i < inv.size(); ++i) {
            if (matchedSlots.get(i) || inv.getItem(i).isEmpty()) continue;
            return List.of();
        }
        return res;
    }

    public static boolean allPresent(CraftingInput inv, List<Predicate<ItemStack>> predicates) {
        return ModCraftingHelper.findItems(inv, predicates).size() == predicates.size();
    }
}

