/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.upgrades;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.upgrade.IUpgradeItem;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.upgrades.IUpgradeHolder;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class UpgradeCache {
    private byte[] countCache;
    private final IUpgradeHolder holder;
    private Direction ejectDirection;

    public UpgradeCache(IUpgradeHolder holder) {
        this.holder = holder;
    }

    public void invalidateCache() {
        this.countCache = null;
    }

    public int getUpgrades(PNCUpgrade type) {
        this.validateCache();
        return this.countCache[type.getCacheId()];
    }

    public Optional<Direction> getEjectDirection() {
        return Optional.ofNullable(this.ejectDirection);
    }

    public void validateCache() {
        if (this.countCache != null) {
            return;
        }
        this.countCache = new byte[this.largestID() + 1];
        IItemHandler handler = this.holder.getUpgradeHandler();
        this.ejectDirection = null;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            Item item = stack.getItem();
            if (item instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)item;
                PNCUpgrade upgradeType = upgradeItem.getUpgradeType();
                if (this.countCache[upgradeType.getCacheId()] != 0) {
                    Log.warning("found upgrade {} in multiple slots! Ignoring.", upgradeType);
                    continue;
                }
                this.countCache[upgradeType.getCacheId()] = (byte)(stack.getCount() * upgradeItem.getUpgradeTier());
                this.handleExtraData(stack, upgradeType);
                continue;
            }
            if (stack.isEmpty()) continue;
            throw new IllegalStateException("found non-upgrade item in an upgrade handler! " + String.valueOf(stack));
        }
        this.holder.onUpgradesChanged();
    }

    private int largestID() {
        int max = 0;
        for (PNCUpgrade upgrade : PneumaticRegistry.getInstance().getUpgradeRegistry().getKnownUpgrades()) {
            max = Math.max(max, upgrade.getCacheId());
        }
        return max;
    }

    private void handleExtraData(ItemStack stack, PNCUpgrade type) {
        if (type == ModUpgrades.DISPENSER.get()) {
            this.ejectDirection = (Direction)stack.get(ModDataComponents.EJECT_DIR);
        }
    }
}

