/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.upgrades;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.upgrade.IUpgradeRegistry;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;

public class UpgradesDBSetup {
    private static final int MAX_VOLUME = 25;
    public static final int MAX_INVENTORY = 35;
    private static final IUpgradeRegistry.Builder DRONE_UPGRADES = new IUpgradeRegistry.Builder().with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.INVENTORY.get(), 35).with(ModUpgrades.ITEM_LIFE.get(), 10).with(ModUpgrades.SECURITY.get(), 3).with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.MINIGUN.get(), 1).with(ModUpgrades.MAGNET.get(), 6).with(ModUpgrades.ARMOR.get(), 15).with(ModUpgrades.RANGE.get(), 16).with(ModUpgrades.CREATIVE.get(), 1).with(ModUpgrades.CHUNKLOADER.get(), 3).with(ModUpgrades.MUFFLER.get(), 4);
    private static final IUpgradeRegistry.Builder BASIC_DRONE_UPGRADES = new IUpgradeRegistry.Builder().with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.ITEM_LIFE.get(), 10).with(ModUpgrades.SECURITY.get(), 3).with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.ARMOR.get(), 15).with(ModUpgrades.STANDBY.get(), 1);
    private static final IUpgradeRegistry.Builder GUARD_DRONE_UPGRADES = IUpgradeRegistry.Builder.copyOf(BASIC_DRONE_UPGRADES).with(ModUpgrades.MINIGUN.get(), 1).with(ModUpgrades.RANGE.get(), 16).with(ModUpgrades.CREATIVE.get(), 1).with(ModUpgrades.MUFFLER.get(), 4);
    private static final IUpgradeRegistry.Builder COLLECTOR_DRONE_UPGRADES = IUpgradeRegistry.Builder.copyOf(BASIC_DRONE_UPGRADES).with(ModUpgrades.MAGNET.get(), 6).with(ModUpgrades.RANGE.get(), 16).with(ModUpgrades.INVENTORY.get(), 35);
    private static final IUpgradeRegistry.Builder LOGISTICS_DRONE_UPGRADES = IUpgradeRegistry.Builder.copyOf(BASIC_DRONE_UPGRADES).with(ModUpgrades.INVENTORY.get(), 35);

    public static void init() {
        UpgradesDBSetup.initTileEntities();
        UpgradesDBSetup.initEntities();
        UpgradesDBSetup.initItems();
    }

    private static void initItems() {
        ApplicableUpgradesDB db = ApplicableUpgradesDB.getInstance();
        db.addApplicableUpgrades((Item)ModItems.DRONE.get(), DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.HARVESTING_DRONE.get(), BASIC_DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.GUARD_DRONE.get(), GUARD_DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.COLLECTOR_DRONE.get(), COLLECTOR_DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.LOGISTICS_DRONE.get(), LOGISTICS_DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.MINIGUN.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 3).with(ModUpgrades.RANGE.get(), 6).with(ModUpgrades.DISPENSER.get(), 3).with(ModUpgrades.ITEM_LIFE.get(), 4).with(ModUpgrades.ENTITY_TRACKER.get(), 4).with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.CREATIVE.get(), 1).with(ModUpgrades.MUFFLER.get(), 4));
        db.addApplicableUpgrades((Item)ModItems.JACKHAMMER.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.MAGNET.get(), 1).with(ModUpgrades.MUFFLER.get(), 4));
        db.addApplicableUpgrades((Item)ModItems.AMADRON_TABLET.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.VOLUME.get(), 25));
        List<IUpgradeRegistry.Builder> armor = Arrays.asList(new IUpgradeRegistry.Builder(), new IUpgradeRegistry.Builder(), new IUpgradeRegistry.Builder(), new IUpgradeRegistry.Builder());
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).forEach(handler -> Arrays.stream(handler.getRequiredUpgrades()).forEach(upgrade -> ((IUpgradeRegistry.Builder)armor.get(slot.getIndex())).with((PNCUpgrade)upgrade, handler.getMaxInstallableUpgrades((PNCUpgrade)upgrade))));
            armor.get(slot.getIndex()).with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.ITEM_LIFE.get(), 5).with(ModUpgrades.ARMOR.get(), 4).with(ModUpgrades.RADIATION_SHIELDING.get(), 1).with(ModUpgrades.GILDED.get(), 1).with(ModUpgrades.THAUMCRAFT.get(), 1).with(ModUpgrades.CREATIVE.get(), 1);
        }
        armor.get(EquipmentSlot.HEAD.getIndex()).with(ModUpgrades.RANGE.get(), 5).with(ModUpgrades.SECURITY.get(), 64);
        armor.get(EquipmentSlot.CHEST.getIndex()).with(ModUpgrades.SECURITY.get(), 1);
        armor.get(EquipmentSlot.FEET.getIndex()).with(ModUpgrades.FLIPPERS.get(), 1);
        armor.get(EquipmentSlot.FEET.getIndex()).with(ModUpgrades.MUFFLER.get(), 4);
        db.addApplicableUpgrades((Item)ModItems.PNEUMATIC_HELMET.get(), armor.get(EquipmentSlot.HEAD.getIndex()));
        db.addApplicableUpgrades((Item)ModItems.PNEUMATIC_CHESTPLATE.get(), armor.get(EquipmentSlot.CHEST.getIndex()));
        db.addApplicableUpgrades((Item)ModItems.PNEUMATIC_LEGGINGS.get(), armor.get(EquipmentSlot.LEGS.getIndex()));
        db.addApplicableUpgrades((Item)ModItems.PNEUMATIC_BOOTS.get(), armor.get(EquipmentSlot.FEET.getIndex()));
    }

    private static void initEntities() {
        ApplicableUpgradesDB db = ApplicableUpgradesDB.getInstance();
        db.addApplicableUpgrades(ModEntityTypes.DRONE.get(), DRONE_UPGRADES);
        db.addApplicableUpgrades(ModEntityTypes.HARVESTING_DRONE.get(), BASIC_DRONE_UPGRADES);
        db.addApplicableUpgrades(ModEntityTypes.GUARD_DRONE.get(), GUARD_DRONE_UPGRADES);
        db.addApplicableUpgrades(ModEntityTypes.COLLECTOR_DRONE.get(), COLLECTOR_DRONE_UPGRADES);
        db.addApplicableUpgrades(ModEntityTypes.LOGISTICS_DRONE.get(), LOGISTICS_DRONE_UPGRADES);
    }

    private static void initTileEntities() {
        ApplicableUpgradesDB db = ApplicableUpgradesDB.getInstance();
        db.addApplicableUpgrades(ModBlockEntityTypes.AIR_CANNON.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.RANGE.get(), 8).with(ModUpgrades.ITEM_LIFE.get(), 8).with(ModUpgrades.ENTITY_TRACKER.get(), 1).with(ModUpgrades.BLOCK_TRACKER.get(), 1).with(ModUpgrades.DISPENSER.get(), 1).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.AIR_COMPRESSOR.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.ADVANCED_AIR_COMPRESSOR.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.ASSEMBLY_CONTROLLER.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.CHARGING_STATION.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.ELEVATOR_BASE.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.CHARGING.get(), 4));
        db.addApplicableUpgrades(ModBlockEntityTypes.PNEUMATIC_DOOR_BASE.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.RANGE.get(), 8));
        db.addApplicableUpgrades(ModBlockEntityTypes.PRESSURE_CHAMBER_INTERFACE.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.PRESSURE_CHAMBER_VALVE.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25));
        db.addApplicableUpgrades(ModBlockEntityTypes.VACUUM_PUMP.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.UV_LIGHT_BOX.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.DISPENSER.get(), 1).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.SECURITY_STATION.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.ENTITY_TRACKER.get(), 12).with(ModUpgrades.SECURITY.get(), 64).with(ModUpgrades.RANGE.get(), 14));
        db.addApplicableUpgrades(ModBlockEntityTypes.AERIAL_INTERFACE.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.ELECTROSTATIC_COMPRESSOR.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25));
        db.addApplicableUpgrades(ModBlockEntityTypes.OMNIDIRECTIONAL_HOPPER.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SPEED.get(), 11).with(ModUpgrades.CREATIVE.get(), 1).with(ModUpgrades.ENTITY_TRACKER.get(), 1).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.LIQUID_HOPPER.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SPEED.get(), 11).with(ModUpgrades.CREATIVE.get(), 1).with(ModUpgrades.ENTITY_TRACKER.get(), 1).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.LIQUID_COMPRESSOR.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.ADVANCED_LIQUID_COMPRESSOR.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.PROGRAMMABLE_CONTROLLER.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.MAGNET.get(), 6).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.INVENTORY.get(), 35));
        db.addApplicableUpgrades(ModBlockEntityTypes.GAS_LIFT.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.THERMOPNEUMATIC_PROCESSING_PLANT.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.SENTRY_TURRET.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.CREATIVE.get(), 1).with(ModUpgrades.RANGE.get(), 16).with(ModUpgrades.MUFFLER.get(), 4));
        db.addApplicableUpgrades(ModBlockEntityTypes.FLUX_COMPRESSOR.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.PNEUMATIC_DYNAMO.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10));
        db.addApplicableUpgrades(ModBlockEntityTypes.THERMAL_COMPRESSOR.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25));
        db.addApplicableUpgrades(ModBlockEntityTypes.TANK_SMALL.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SPEED.get(), 7).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.TANK_MEDIUM.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SPEED.get(), 7).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.TANK_LARGE.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SPEED.get(), 7).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.TANK_HUGE.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SPEED.get(), 7).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.SMART_CHEST.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SPEED.get(), 9).with(ModUpgrades.DISPENSER.get(), 1).with(ModUpgrades.MAGNET.get(), 1).with(ModUpgrades.RANGE.get(), 4));
        db.addApplicableUpgrades(ModBlockEntityTypes.FLUID_MIXER.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.DISPENSER.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.VACUUM_TRAP.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.RANGE.get(), 6).with(ModUpgrades.SECURITY.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.SPAWNER_EXTRACTOR.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.VOLUME.get(), 25));
        db.addApplicableUpgrades(ModBlockEntityTypes.PRESSURIZED_SPAWNER.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.RANGE.get(), 6).with(ModUpgrades.SPEED.get(), 10).with(ModUpgrades.SECURITY.get(), 1));
        db.addApplicableUpgrades(ModBlockEntityTypes.SOLAR_COMPRESSOR.get(), new IUpgradeRegistry.Builder().with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25).with(ModUpgrades.SPEED.get(), 10));
        IUpgradeRegistry.Builder sensorBuilder = new IUpgradeRegistry.Builder();
        SensorHandler.getInstance().getUniversalSensorUpgrades().forEach(upgrade -> sensorBuilder.with((PNCUpgrade)upgrade, 1));
        sensorBuilder.with(ModUpgrades.RANGE.get(), 64).with(ModUpgrades.SECURITY.get(), 1).with(ModUpgrades.VOLUME.get(), 25);
        db.addApplicableUpgrades(ModBlockEntityTypes.UNIVERSAL_SENSOR.get(), sensorBuilder);
    }
}

