/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidFilter {
    public static final Codec<FluidFilter> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FluidStack.OPTIONAL_CODEC.listOf().fieldOf("stacks").forGetter(filter -> filter.fluidStacks)).apply((Applicative)builder, FluidFilter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidFilter> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), filter -> filter.fluidStacks, FluidFilter::new);
    private final NonNullList<FluidStack> fluidStacks;

    private FluidFilter(List<FluidStack> stacks) {
        this.fluidStacks = NonNullList.createWithCapacity((int)stacks.size());
        this.fluidStacks.addAll(stacks);
    }

    public FluidFilter(int size) {
        this.fluidStacks = NonNullList.withSize((int)size, (Object)FluidStack.EMPTY);
    }

    public int size() {
        return this.fluidStacks.size();
    }

    public void setFluid(int filterIndex, FluidStack stack) {
        if (filterIndex >= 0 && filterIndex < this.fluidStacks.size()) {
            this.fluidStacks.set(filterIndex, (Object)stack);
        }
    }

    public FluidStack getFluid(int filterIndex) {
        return filterIndex >= 0 && filterIndex < this.fluidStacks.size() ? (FluidStack)this.fluidStacks.get(filterIndex) : FluidStack.EMPTY;
    }

    public boolean matchFluid(Fluid fluid) {
        return this.fluidStacks.stream().anyMatch(filterStack -> !filterStack.isEmpty() && filterStack.getFluid() == fluid);
    }
}

