/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.util.entityfilter.EntityFilter;
import net.minecraft.world.entity.Entity;

public class StringFilterEntitySelector
implements Predicate<Entity> {
    private List<EntityFilter> filters = new ArrayList<EntityFilter>();

    public boolean apply(Entity entity) {
        return this.getFilter().stream().anyMatch(f -> f.test(entity));
    }

    protected List<EntityFilter> getFilter() {
        return this.filters;
    }

    public StringFilterEntitySelector setFilter(String filterStr) {
        EntityFilter filter = EntityFilter.fromString(filterStr);
        if (filter != null) {
            this.filters = new ArrayList<EntityFilter>();
            this.filters.add(filter);
        } else {
            this.filters.clear();
        }
        return this;
    }

    public StringFilterEntitySelector setFilter(List<EntityFilter> filters) {
        this.filters = new ArrayList<EntityFilter>(filters);
        return this;
    }

    public StringFilterEntitySelector addEntry(String filterStr) {
        EntityFilter filter = EntityFilter.fromString(filterStr);
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }
}

