/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.legacyconv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.Util;

public class ConversionUtil {
    static OptionalInt getInt(JsonObject json, String fieldName) {
        JsonObject sub;
        if (json.has(fieldName) && (sub = json.get(fieldName).getAsJsonObject()).has("type") && (sub.get("type").getAsInt() == 3 || sub.get("type").getAsInt() == 1)) {
            return OptionalInt.of(sub.get("value").getAsInt());
        }
        return OptionalInt.empty();
    }

    static Optional<String> getString(JsonObject json, String fieldName) {
        JsonObject sub;
        if (json.has(fieldName) && (sub = json.get(fieldName).getAsJsonObject()).has("type") && sub.get("type").getAsInt() == 8) {
            return Optional.of(sub.get("value").getAsString());
        }
        return Optional.empty();
    }

    static Optional<Boolean> getBool(JsonObject json, String fieldName) {
        JsonObject sub;
        if (json.has(fieldName) && (sub = json.get(fieldName).getAsJsonObject()).has("type") && sub.get("type").getAsInt() == 1) {
            return Optional.of(sub.get("value").getAsByte() != 0);
        }
        return Optional.empty();
    }

    static void convXYZ(JsonObject from, JsonObject to, String prefix, String newKey) {
        int sx = ConversionUtil.getInt(from, prefix + "X").orElse(0);
        int sy = ConversionUtil.getInt(from, prefix + "Y").orElse(0);
        int sz = ConversionUtil.getInt(from, prefix + "Z").orElse(0);
        to.add(newKey, (JsonElement)ConversionUtil.makeArray(sx, sy, sz));
    }

    static String prefixVar(String varName) {
        return varName.isEmpty() || varName.startsWith("%") || varName.startsWith("#") ? varName : "#" + varName;
    }

    static JsonArray makeArray(int ... vals) {
        return (JsonArray)Util.make((Object)new JsonArray(), a -> Arrays.stream(vals).forEach(arg_0 -> ((JsonArray)a).add(arg_0)));
    }
}

