/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.client.provider;

import com.google.common.collect.Sets;
import java.util.Set;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIEntities;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EIKeybinds;
import net.swedz.extended_industrialization.EITags;
import net.swedz.tesseract.neoforge.datagen.mi.MIDatagenHooks;
import net.swedz.tesseract.neoforge.lang.LangInstance;
import net.swedz.tesseract.neoforge.registry.holder.FluidHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class LanguageDatagenProvider
extends LanguageProvider {
    private static final Set<LangInstance<?>> INSTANCES = Sets.newHashSet();

    public static void include(LangInstance<?> instance) {
        INSTANCES.add(instance);
    }

    public LanguageDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "extended_industrialization", "en_us");
    }

    protected void addTranslations() {
        for (LangInstance<?> instance : INSTANCES) {
            instance.datagen((LanguageProvider)this);
        }
        for (ItemHolder item : EIItems.values()) {
            this.add(item.asItem(), item.identifier().englishName());
        }
        this.add("item.extended_industrialization.nyano_helmet", "Nyano Helmet");
        this.add("item.extended_industrialization.nyano_quantum_helmet", "Quantum Nyano Helmet");
        for (FluidHolder fluid : EIFluids.values()) {
            this.add(fluid.block().get(), fluid.identifier().englishName());
        }
        for (EIKeybinds.Keybind keybind : EIKeybinds.Registry.getMappings()) {
            this.add(keybind.descriptionId(), keybind.englishName());
        }
        EITags.translations().forEach((arg_0, arg_1) -> ((LanguageDatagenProvider)this).add(arg_0, arg_1));
        MIDatagenHooks.Client.withLanguageHook((LanguageProvider)this, (String)"extended_industrialization");
        this.add("itemGroup.%s.%s".formatted("extended_industrialization", "extended_industrialization"), "Extended Industrialization");
        this.add(EIKeybinds.CATEGORY, "Extended Industrialization");
        this.add("lef_tier.%s.%s.%s".formatted("extended_industrialization", "modern_industrialization", "cupronickel_coil"), "Cupronickel");
        this.add("lef_tier.%s.%s.%s".formatted("extended_industrialization", "modern_industrialization", "kanthal_coil"), "Kanthal");
        this.add("teslatower_tier.%s.%s.%s".formatted("extended_industrialization", "extended_industrialization", "copper_tesla_winding"), "Copper");
        this.add("teslatower_tier.%s.%s.%s".formatted("extended_industrialization", "extended_industrialization", "electrum_tesla_winding"), "Electrum");
        this.add("teslatower_tier.%s.%s.%s".formatted("extended_industrialization", "extended_industrialization", "aluminum_tesla_winding"), "Aluminum");
        this.add("teslatower_tier.%s.%s.%s".formatted("extended_industrialization", "extended_industrialization", "annealed_copper_tesla_winding"), "Annealed Copper");
        this.add("teslatower_tier.%s.%s.%s".formatted("extended_industrialization", "extended_industrialization", "superconductor_tesla_winding"), "Superconductor");
        this.add(EIEntities.NANO_SABER_SWEEP.get(), "Nano Saber Sweep");
        this.add(EI.id("tesla").toLanguageKey("death.attack"), "%1$s was electrocuted to death");
        this.add(EI.id("nano_saber_sweep").toLanguageKey("death.attack"), "%1$s was vaporized");
        this.add("curios.identifier.shoulders", "Shoulders");
    }
}

