/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.datamaps;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.api.energy.CableTier;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIDataMaps;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.datamap.EnchantmentModule;
import net.swedz.extended_industrialization.datamap.FarmerSimpleTallCropSize;
import net.swedz.extended_industrialization.datamap.FertilizerPotency;
import net.swedz.extended_industrialization.datamap.LargeElectricFurnaceTier;
import net.swedz.extended_industrialization.datamap.TeslaTowerTierData;
import net.swedz.tesseract.neoforge.registry.holder.FluidHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class DataMapDatagenProvider
extends DataMapProvider {
    public DataMapDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider());
    }

    protected void gather() {
        this.addFarmerSimpleTallCropSize(Blocks.SUGAR_CANE, 3);
        this.addFarmerSimpleTallCropSize(Blocks.CACTUS, 3);
        this.addFluidFertilizerPotency((FluidHolder)EIFluids.MANURE, 25, 300);
        this.addFluidFertilizerPotency((FluidHolder)EIFluids.COMPOSTED_MANURE, 25, 150);
        this.addFluidFertilizerPotency((FluidHolder)EIFluids.NPK_FERTILIZER, 10, 30);
        this.addLargeElectricFurnaceTier(MI.id((String)"cupronickel_coil"), 16, 0.75f);
        this.addLargeElectricFurnaceTier(MI.id((String)"kanthal_coil"), 32, 0.75f);
        this.addTeslaTowerTier(EI.id("copper_tesla_winding"), CableTier.LV.getMaxTransfer() * 6L, 32, 64L);
        this.addTeslaTowerTier(EI.id("electrum_tesla_winding"), CableTier.MV.getMaxTransfer() * 6L, 64, 256L);
        this.addTeslaTowerTier(EI.id("aluminum_tesla_winding"), CableTier.HV.getMaxTransfer() * 6L, 128, 1024L);
        this.addTeslaTowerTier(EI.id("annealed_copper_tesla_winding"), CableTier.EV.getMaxTransfer() * 6L, 256, 4096L);
        this.addTeslaTowerTier(EI.id("superconductor_tesla_winding"), CableTier.SUPERCONDUCTOR.getMaxTransfer() * 6L, 512, 16384L);
        this.addEnchantmentModule(EIItems.SILK_TOUCH_MODULE, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, 1, 16L);
        this.addEnchantmentModule(EIItems.LOOTING_MODULE, (ResourceKey<Enchantment>)Enchantments.LOOTING, 1, 32L, Map.of(CableTier.MV, new EnchantmentModule.Value(3, 128L), CableTier.HV, new EnchantmentModule.Value(5, 512L), CableTier.EV, new EnchantmentModule.Value(7, 8192L), CableTier.SUPERCONDUCTOR, new EnchantmentModule.Value(10, 32768L)));
    }

    private void addFarmerSimpleTallCropSize(ResourceLocation block, int maxHeight) {
        this.builder(EIDataMaps.FARMER_SIMPLE_TALL_CROP_SIZE).add(block, (Object)new FarmerSimpleTallCropSize(maxHeight), false, new ICondition[0]);
    }

    private void addFarmerSimpleTallCropSize(Block block, int maxHeight) {
        this.addFarmerSimpleTallCropSize(BuiltInRegistries.BLOCK.getKey((Object)block), maxHeight);
    }

    private void addFluidFertilizerPotency(FluidHolder fluid, int tickRate, int mbToConsumePerFertilizerTick) {
        this.builder(EIDataMaps.FERTILIZER_POTENCY).add(fluid.identifier().location(), (Object)new FertilizerPotency(tickRate, mbToConsumePerFertilizerTick), false, new ICondition[0]);
    }

    private void addLargeElectricFurnaceTier(ResourceLocation block, int batchSize, float euCostMultiplier) {
        this.builder(EIDataMaps.LARGE_ELECTRIC_FURNACE_TIER).add(block, (Object)new LargeElectricFurnaceTier(batchSize, euCostMultiplier), false, new ICondition[0]);
    }

    private void addTeslaTowerTier(ResourceLocation block, long maxTransfer, int maxDistance, long drain) {
        this.builder(EIDataMaps.TESLA_TOWER_TIER).add(block, (Object)new TeslaTowerTierData(maxTransfer, maxDistance, drain), false, new ICondition[0]);
    }

    private void addEnchantmentModule(ItemHolder item, ResourceKey<Enchantment> enchantment, int level, long euCost, Map<CableTier, EnchantmentModule.Value> values) {
        this.builder(EIDataMaps.ENCHANTMENT_MODULE).add(item.identifier().location(), (Object)new EnchantmentModule(enchantment, new EnchantmentModule.Value(level, euCost), values), false, new ICondition[0]);
    }

    private void addEnchantmentModule(ItemHolder item, ResourceKey<Enchantment> enchantment, int level, long euCost) {
        this.addEnchantmentModule(item, enchantment, level, euCost, Map.of());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

