/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.recipes;

import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialRegistry;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.property.MaterialHardness;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import java.util.Map;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EIMachines;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.RecipesServerDatagenProvider;
import net.swedz.tesseract.neoforge.compat.mi.recipe.MIMachineRecipeBuilder;

public final class BendingMachineRecipesServerDatagenProvider
extends RecipesServerDatagenProvider {
    public BendingMachineRecipesServerDatagenProvider(GatherDataEvent event) {
        super(event);
    }

    private static void addBendingMachineRecipes(String name, Material material, PartTemplate from, PartTemplate to, RecipeOutput output) {
        if (BendingMachineRecipesServerDatagenProvider.hasPart(material, from) && BendingMachineRecipesServerDatagenProvider.hasPart(material, to)) {
            BendingMachineRecipesServerDatagenProvider.addMaterialMachineRecipe(material, name, EIMachines.RecipeTypes.BENDING_MACHINE, 2, (int)(200.0 * ((MaterialHardness)material.get((MaterialProperty)MaterialProperty.HARDNESS)).timeFactor / 2.0), r -> ((MIMachineRecipeBuilder)r.addItemInput(material.getPart((PartKeyProvider)from).getTaggedIngredient(), 1, 1.0f)).addItemOutput((ItemLike)material.getPart((PartKeyProvider)to), 1), output);
        }
    }

    protected void buildRecipes(RecipeOutput output) {
        for (Map.Entry entry : MaterialRegistry.getMaterials().entrySet()) {
            Material material = (Material)entry.getValue();
            BendingMachineRecipesServerDatagenProvider.addBendingMachineRecipes("plate", material, MIParts.PLATE, MIParts.CURVED_PLATE, output);
            BendingMachineRecipesServerDatagenProvider.addBendingMachineRecipes("ring", material, MIParts.ROD, MIParts.RING, output);
        }
    }
}

