/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item;

import aztech.modern_industrialization.MIComponents;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.tesseract.neoforge.item.ItemHurtHandler;

public class ElectricArmorItem
extends ArmorItem
implements ISimpleEnergyItem,
ItemHurtHandler {
    private final long energyCapacity;
    private final long damageCostEnergy;

    public ElectricArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, long energyCapacity, long damageCostEnergy) {
        super(material, type, properties.stacksTo(1).component(EIComponents.HIDE_BAR, (Object)false).component(MIComponents.ENERGY, (Object)0L));
        this.energyCapacity = energyCapacity;
        this.damageCostEnergy = damageCostEnergy;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.getModifiedDefaultAttributeModifiers(stack, this.getStoredEnergy(stack) > 0L ? (ItemAttributeModifiers)this.defaultModifiers.get() : ItemAttributeModifiers.EMPTY);
    }

    public ItemAttributeModifiers getModifiedDefaultAttributeModifiers(ItemStack stack, ItemAttributeModifiers modifiers) {
        return modifiers;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public DataComponentType<Long> getEnergyComponent() {
        return (DataComponentType)MIComponents.ENERGY.get();
    }

    public long getEnergyCapacity(ItemStack stack) {
        return this.energyCapacity;
    }

    public long getEnergyMaxInput(ItemStack stack) {
        return this.energyCapacity;
    }

    public long getEnergyMaxOutput(ItemStack stack) {
        return this.energyCapacity;
    }

    public boolean hasEnergy(ItemStack stack) {
        return this.getStoredEnergy(stack) >= this.damageCostEnergy;
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Boolean)stack.getOrDefault(EIComponents.HIDE_BAR, (Object)false) == false;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round((double)this.getStoredEnergy(stack) / (double)this.energyCapacity * 13.0);
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF0000;
    }

    public void onHurt(LivingEntity entity, ItemStack stack, int damageAmount) {
        if (this.getStoredEnergy(stack) > 0L) {
            this.tryUseEnergy(stack, this.damageCostEnergy);
        }
    }
}

