/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.nanosuit.decoration;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitArmorItem;
import net.swedz.extended_industrialization.item.nanosuit.decoration.MeowNanoDecoration;
import net.swedz.extended_industrialization.item.nanosuit.decoration.WingNanoDecoration;

public interface NanoSuitDecoration {
    public static final WingNanoDecoration WING = new WingNanoDecoration();
    public static final MeowNanoDecoration MEOW = new MeowNanoDecoration();

    public static List<NanoSuitDecoration> values() {
        return List.of(WING, MEOW);
    }

    public boolean isActiveFor(NanoSuitArmorItem var1, ItemStack var2);

    public ArmorItem.Type armorType();

    default public EquipmentSlot equipmentSlot() {
        return this.armorType().getSlot();
    }

    default public EquipmentSlotGroup equipmentSlotGroup() {
        return EquipmentSlotGroup.bySlot((EquipmentSlot)this.equipmentSlot());
    }

    default public String getDescriptionId(NanoSuitArmorItem item, ItemStack stack) {
        return null;
    }

    default public Optional<List<Component>> getTooltipLines(NanoSuitArmorItem item, ItemStack stack) {
        return Optional.empty();
    }

    default public ItemProperty itemProperty(NanoSuitArmorItem item) {
        return null;
    }

    public record ItemProperty(ResourceLocation id, String model, Supplier<DataComponentType<Boolean>> component) {
    }
}

