/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.teslalinkable;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.item.teslalinkable.SelectedTeslaNetwork;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiver;
import net.swedz.extended_industrialization.machines.component.tesla.network.transmitter.TeslaTransmitter;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.tooltip.component.ItemStackTooltipComponent;

@EventBusSubscriber(modid="extended_industrialization")
public final class TeslaCalibratorItem
extends Item {
    public TeslaCalibratorItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void onPlaceReceiverWithCalibrator(BlockEvent.EntityPlaceEvent event) {
        Player player;
        ItemStack offhand;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (offhand = (player = (Player)entity).getItemInHand(InteractionHand.OFF_HAND)).has(EIComponents.SELECTED_TESLA_NETWORK)) {
            WorldPos key = ((SelectedTeslaNetwork)offhand.get(EIComponents.SELECTED_TESLA_NETWORK)).key();
            BlockEntity blockEntity = event.getLevel().getBlockEntity(event.getPos());
            if (blockEntity instanceof MachineBlockEntity) {
                MachineBlockEntity machine = (MachineBlockEntity)blockEntity;
                if (blockEntity instanceof TeslaReceiver) {
                    TeslaReceiver receiver = (TeslaReceiver)blockEntity;
                    receiver.setNetwork(key);
                    machine.setChanged();
                    machine.sync();
                    player.displayClientMessage((Component)EI.text().teslaCalibratorLinkSuccess(), true);
                }
            }
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        boolean client = context.getLevel().isClientSide();
        Player player = context.getPlayer();
        if (player != null) {
            InteractionHand usedHand = context.getHand();
            ItemStack itemStack = player.getItemInHand(usedHand);
            BlockEntity hitBlockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
            if (player.isShiftKeyDown() && hitBlockEntity instanceof TeslaTransmitter) {
                TeslaTransmitter transmitter = (TeslaTransmitter)hitBlockEntity;
                if (!client) {
                    itemStack.set(EIComponents.SELECTED_TESLA_NETWORK, (Object)new SelectedTeslaNetwork(transmitter.getPosition(), context.getLevel().getBlockState(context.getClickedPos()).getBlock()));
                    player.displayClientMessage((Component)EI.text().teslaCalibratorSelected(), true);
                }
                return InteractionResult.sidedSuccess((boolean)client);
            }
            if (!player.isShiftKeyDown() && hitBlockEntity instanceof MachineBlockEntity) {
                MachineBlockEntity machine = (MachineBlockEntity)hitBlockEntity;
                if (hitBlockEntity instanceof TeslaReceiver) {
                    TeslaReceiver receiver = (TeslaReceiver)hitBlockEntity;
                    if (!client) {
                        if (itemStack.has(EIComponents.SELECTED_TESLA_NETWORK)) {
                            WorldPos key = ((SelectedTeslaNetwork)itemStack.get(EIComponents.SELECTED_TESLA_NETWORK)).key();
                            receiver.setNetwork(key);
                            machine.setChanged();
                            machine.sync();
                            player.displayClientMessage((Component)EI.text().teslaCalibratorLinkSuccess(), true);
                        } else {
                            player.displayClientMessage((Component)EI.text().teslaCalibratorLinkFailedNoSelection(), true);
                        }
                    }
                    return InteractionResult.sidedSuccess((boolean)client);
                }
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player.isShiftKeyDown()) {
            player.getItemInHand(usedHand).remove(EIComponents.SELECTED_TESLA_NETWORK);
            player.displayClientMessage((Component)EI.text().teslaCalibratorClear(), true);
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(usedHand), (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag isAdvanced) {
        if (stack.has(EIComponents.SELECTED_TESLA_NETWORK)) {
            WorldPos key = ((SelectedTeslaNetwork)stack.get(EIComponents.SELECTED_TESLA_NETWORK)).key();
            lines.add((Component)EI.text().teslaCalibratorLinked(key));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (stack.has(EIComponents.SELECTED_TESLA_NETWORK)) {
            Block machineBlock = ((SelectedTeslaNetwork)stack.get(EIComponents.SELECTED_TESLA_NETWORK)).block();
            Item item = machineBlock.asItem();
            return Optional.of(new ItemStackTooltipComponent(item.getDefaultInstance()));
        }
        return Optional.empty();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !newStack.is(oldStack.getItem());
    }
}

