/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.brewery;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.LubricantHelper;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.blockentity.brewery.BreweryMachineBlockEntity;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.MachineGuiConfiguration;

public final class ElectricBreweryMachineBlockEntity
extends BreweryMachineBlockEntity
implements EnergyComponentHolder {
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final CasingComponent casing = new CasingComponent();
    private final UpgradeComponent upgrades = new UpgradeComponent();
    private final OverdriveComponent overdrive = new OverdriveComponent();
    private final EnergyComponent energy = new EnergyComponent((BlockEntity)this, () -> ((CasingComponent)this.casing).getEuCapacity());
    private final MIEnergyStorage insertable = this.energy.buildInsertable(arg_0 -> ((CasingComponent)this.casing).canInsertEu(arg_0));

    public ElectricBreweryMachineBlockEntity(BEP bep, MachineGuiConfiguration gui) {
        super(bep, MachineTier.LV, gui.createGuiParams(EI.id("electric_brewery")), gui.buildInventory());
        gui.registerProgressBar((MachineBlockEntity)this, () -> ((CrafterComponent)this.crafter).getProgress());
        gui.registerEnergyBar((MachineBlockEntity)this, () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        gui.registerEfficiencyBar((MachineBlockEntity)this, this.crafter);
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades).withCasing(this.casing).withOverdrive(this.overdrive)});
        this.registerComponents(new IComponent[]{this.energy, this.redstoneControl, this.casing, this.upgrades, this.overdrive});
    }

    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this);
    }

    public long consumeEu(long max, Simulation simulation) {
        return this.energy.consumeEu(max, simulation);
    }

    @Override
    public long getMaxRecipeEu() {
        return (long)this.tier.getMaxEu() + this.upgrades.getAddMaxEUPerTick();
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public boolean isOverdriving() {
        return this.overdrive.shouldOverdrive();
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.casing.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.upgrades.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = LubricantHelper.onUse((CrafterComponent)this.crafter, (Player)player, (InteractionHand)hand);
        }
        return result;
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.casing.getCasing());
        this.orientation.writeModelData(data);
        data.isActive = this.isActiveComponent.isActive;
        return data;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((ElectricBreweryMachineBlockEntity)be).insertable));
    }
}

