/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla.network.receiver;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetwork;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiver;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiverState;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanelBuilder;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import net.swedz.tesseract.neoforge.proxy.builtin.TesseractProxy;

public class TeslaReceiverComponent
implements IComponent,
TeslaReceiver {
    private static final int PRIORITY_RANGE = 16;
    private final MachineBlockEntity machine;
    private final MIEnergyStorage insertable;
    private final Supplier<Boolean> canOperate;
    private final Supplier<CableTier> cableTier;
    private Optional<WorldPos> networkKey = Optional.empty();
    private int priority = 0;

    public TeslaReceiverComponent(MachineBlockEntity machine, MIEnergyStorage energyInsertable, Supplier<Boolean> canOperate, Supplier<CableTier> cableTier) {
        this.machine = machine;
        this.insertable = energyInsertable;
        this.canOperate = canOperate;
        this.cableTier = cableTier;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public TeslaReceiverState checkReceiveFrom(TeslaNetwork network) {
        if (this.getCableTier() != network.getCableTier()) {
            return TeslaReceiverState.MISMATCHING_VOLTAGE;
        }
        if (this.machine.hasLevel()) {
            return TeslaReceiver.super.checkReceiveFrom(network);
        }
        return TeslaReceiverState.UNDEFINED;
    }

    @Override
    public boolean hasNetwork() {
        return this.networkKey.isPresent();
    }

    @Override
    public WorldPos getNetworkKey() {
        return this.networkKey.orElseThrow();
    }

    @Override
    public void setNetwork(WorldPos key) {
        if (!((TesseractProxy)Proxies.get(TesseractProxy.class)).hasServer()) {
            throw new IllegalStateException("Cannot set network of a receiver from the client");
        }
        this.removeFromNetwork();
        this.networkKey = Optional.ofNullable(key);
        this.addToNetwork();
    }

    @Override
    public WorldPos getPosition() {
        return new WorldPos(this.machine.getLevel(), this.machine.getBlockPos());
    }

    @Override
    public WorldPos getSourcePosition() {
        return this.getPosition();
    }

    @Override
    public CableTier getCableTier() {
        return this.cableTier.get();
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (!this.canOperate.get().booleanValue()) {
            return 0L;
        }
        return this.insertable.receive(maxReceive, simulate);
    }

    @Override
    public long getStoredEnergy() {
        return this.insertable.getAmount();
    }

    @Override
    public long getEnergyCapacity() {
        return this.insertable.getCapacity();
    }

    public void removeFromNetwork() {
        if (this.hasNetwork()) {
            this.getNetwork().remove(this);
        }
    }

    public void addToNetwork() {
        if (this.hasNetwork()) {
            this.getNetwork().add(this);
        }
    }

    private List<Component> createPriorityTranslations() {
        ArrayList lines = Lists.newArrayList();
        for (int priority = -16; priority <= 16; ++priority) {
            lines.add(EI.text().priority(priority));
        }
        return lines;
    }

    public void appendSelectionPanel(MachineBlockEntity machine, ConfigurationPanelBuilder builder) {
        builder.add(this.createPriorityTranslations(), false, delta -> {
            int newPriority = this.priority + delta;
            if (newPriority >= -16 && newPriority <= 16) {
                this.priority = newPriority;
            }
        }, () -> this.priority + 16);
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.hasNetwork()) {
            WorldPos key = this.getNetworkKey();
            WorldPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)key).result().ifPresent(t -> tag.put("network_key", t));
        }
        tag.putInt("priority", this.priority);
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        if (tag.contains("network_key", 10)) {
            CompoundTag keyTag = tag.getCompound("network_key");
            this.setNetwork(WorldPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)keyTag).result().orElse(null));
        } else {
            this.setNetwork(null);
        }
        this.priority = Mth.clamp((int)tag.getInt("priority"), (int)-16, (int)16);
    }

    public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("network_key", 10)) {
            CompoundTag keyTag = tag.getCompound("network_key");
            this.networkKey = WorldPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)keyTag).result();
        } else {
            this.networkKey = Optional.empty();
        }
        this.priority = Mth.clamp((int)tag.getInt("priority"), (int)-16, (int)16);
    }
}

