/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.solarefficiency;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.RenderHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.guicomponent.solarefficiency.SolarEfficiencyBar;

public final class SolarEfficiencyBarClient
implements GuiComponentClient {
    public final SolarEfficiencyBar.Parameters params;
    public boolean working;
    public int efficiency;
    public boolean hasCalcification;
    public int calcification;
    public boolean hasEnergyProduced;
    public long energyProduced;

    public SolarEfficiencyBarClient(RegistryFriendlyByteBuf buf) {
        this.params = new SolarEfficiencyBar.Parameters(buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    public void readCurrentData(RegistryFriendlyByteBuf buf) {
        this.working = buf.readBoolean();
        this.efficiency = buf.readInt();
        this.hasCalcification = buf.readBoolean();
        if (this.hasCalcification) {
            this.calcification = buf.readInt();
        }
        this.hasEnergyProduced = buf.readBoolean();
        if (this.hasEnergyProduced) {
            this.energyProduced = buf.readLong();
        }
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    private final class Renderer
    implements ClientComponentRenderer {
        private static final ResourceLocation EFFICIENCY_BAR = MI.id((String)"textures/gui/efficiency_bar.png");
        private static final ResourceLocation SOLAR_STATE = EI.id("textures/gui/container/solar_state.png");
        private final int WIDTH = 100;
        private final int HEIGHT = 2;

        private Renderer() {
        }

        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            guiGraphics.blit(EFFICIENCY_BAR, x + SolarEfficiencyBarClient.this.params.renderX() - 1, y + SolarEfficiencyBarClient.this.params.renderY() - 1, 0.0f, 2.0f, 102, 4, 102, 6);
            int barPixels = (int)((float)SolarEfficiencyBarClient.this.efficiency / 100.0f * 100.0f);
            guiGraphics.blit(EFFICIENCY_BAR, x + SolarEfficiencyBarClient.this.params.renderX(), y + SolarEfficiencyBarClient.this.params.renderY(), 0.0f, 0.0f, barPixels, 2, 102, 6);
            guiGraphics.blit(SOLAR_STATE, x + SolarEfficiencyBarClient.this.params.renderX() - 20, y + SolarEfficiencyBarClient.this.params.renderY() + 1 - 6, SolarEfficiencyBarClient.this.working ? 0.0f : 12.0f, 0.0f, 12, 12, 24, 12);
        }

        public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle((int)SolarEfficiencyBarClient.this.params.renderX(), (int)SolarEfficiencyBarClient.this.params.renderY(), (int)100, (int)2, (double)(cursorX - x), (double)(cursorY - y))) {
                ArrayList lines = Lists.newArrayList();
                lines.add(EI.text().solarEfficiency(SolarEfficiencyBarClient.this.efficiency));
                if (SolarEfficiencyBarClient.this.hasCalcification) {
                    lines.add(EI.text().calcificationPercentage(SolarEfficiencyBarClient.this.calcification));
                }
                if (SolarEfficiencyBarClient.this.hasEnergyProduced) {
                    lines.add(EI.text().generatingEuPerTick(SolarEfficiencyBarClient.this.energyProduced));
                }
                guiGraphics.renderTooltip(font, (List)lines, Optional.empty(), cursorX, cursorY);
            }
        }
    }
}

