/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.teslanetwork;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.RenderHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiverState;
import net.swedz.extended_industrialization.machines.guicomponent.teslanetwork.TeslaNetworkBar;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.helper.ComponentHelper;

public final class TeslaNetworkBarClient
implements GuiComponentClient {
    private final TeslaNetworkBar.Parameters params;
    private Optional<TeslaNetworkBar.Data> data = Optional.empty();

    public TeslaNetworkBarClient(RegistryFriendlyByteBuf buf) {
        this.params = new TeslaNetworkBar.Parameters(buf.readVarInt(), buf.readVarInt());
        this.readCurrentData(buf);
    }

    public void readCurrentData(RegistryFriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            int type = buf.readVarInt();
            if (type == 0) {
                int receivers = buf.readVarInt();
                long energyTransmitting = buf.readVarLong();
                CableTier cableTier = CableTier.getTier((String)buf.readUtf());
                long energyDrain = buf.readVarLong();
                long energyConsuming = buf.readVarLong();
                this.data = Optional.of(new TeslaNetworkBar.TransmitterData(receivers, energyTransmitting, cableTier, energyDrain, energyConsuming));
            } else if (type == 1) {
                TeslaReceiverState state = (TeslaReceiverState)buf.readEnum(TeslaReceiverState.class);
                Optional linked = buf.readOptional((StreamDecoder)WorldPos.STREAM_CODEC);
                Optional<CableTier> networkCableTier = Optional.empty();
                if (linked.isPresent() && buf.readBoolean()) {
                    networkCableTier = Optional.of(CableTier.getTier((String)buf.readUtf()));
                }
                this.data = Optional.of(new TeslaNetworkBar.ReceiverData(state, linked, networkCableTier));
            } else if (type == 2) {
                int note = buf.readVarInt();
                long energyConsuming = buf.readVarLong();
                this.data = Optional.of(new TeslaNetworkBar.SingingData(note, energyConsuming));
            }
        } else {
            this.data = Optional.empty();
        }
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new ClientComponentRenderer(){
            private static final ResourceLocation TESLA_NETWORK_BAR = EI.id("textures/gui/container/tesla_network_bar.png");
            private final int WIDTH = 18;
            private final int HEIGHT = 18;

            public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
                int iconIndex = TeslaNetworkBarClient.this.data.map(TeslaNetworkBar.Data::iconIndex).orElse(0);
                guiGraphics.blit(TESLA_NETWORK_BAR, x + TeslaNetworkBarClient.this.params.renderX(), y + TeslaNetworkBarClient.this.params.renderY(), (float)(iconIndex * 18), 0.0f, 18, 18, 126, 18);
            }

            public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
                if (RenderHelper.isPointWithinRectangle((int)TeslaNetworkBarClient.this.params.renderX(), (int)TeslaNetworkBarClient.this.params.renderY(), (int)18, (int)18, (double)(mouseX - x), (double)(mouseY - y))) {
                    ArrayList lines = Lists.newArrayList();
                    if (TeslaNetworkBarClient.this.data.isPresent()) {
                        TeslaNetworkBar.Data data = TeslaNetworkBarClient.this.data.get();
                        if (data instanceof TeslaNetworkBar.TransmitterData) {
                            TeslaNetworkBar.TransmitterData transmitter = (TeslaNetworkBar.TransmitterData)data;
                            lines.add(EI.text().teslaNetworkTransmitterReceivers(transmitter.receivers()));
                            lines.add(EI.text().teslaNetworkTransmitterTransmitting(transmitter.energyTransmitting(), transmitter.cableTier()));
                            lines.add(EI.text().teslaNetworkTransmitterDrain(transmitter.energyDrain()));
                            lines.add(EI.text().teslaNetworkTransmitterConsuming(transmitter.energyConsuming()));
                        } else {
                            data = TeslaNetworkBarClient.this.data.get();
                            if (data instanceof TeslaNetworkBar.ReceiverData) {
                                TeslaNetworkBar.ReceiverData receiver = (TeslaNetworkBar.ReceiverData)data;
                                if (receiver.linked().isPresent()) {
                                    lines.add(EI.text().teslaNetworkReceiverLinked(receiver.linked().get()));
                                }
                                if (receiver.state().isFailure()) {
                                    switch (receiver.state()) {
                                        case NO_LINK: {
                                            EI.text().teslaNetworkReceiverNoLink();
                                            break;
                                        }
                                        case UNLOADED_TRANSMITTER: {
                                            EI.text().teslaNetworkReceiverUnloaded();
                                            break;
                                        }
                                        case MISMATCHING_VOLTAGE: {
                                            EI.text().teslaNetworkReceiverMismatchingVoltage(receiver.networkCableTier().orElseThrow());
                                            break;
                                        }
                                        case TOO_FAR: {
                                            EI.text().teslaNetworkReceiverTooFar();
                                        }
                                    }
                                }
                            } else {
                                data = TeslaNetworkBarClient.this.data.get();
                                if (data instanceof TeslaNetworkBar.SingingData) {
                                    TeslaNetworkBar.SingingData singing = (TeslaNetworkBar.SingingData)data;
                                    lines.add(EI.text().teslaNetworkSingingNote(singing.getReadableNote()));
                                    lines.add(EI.text().teslaNetworkTransmitterConsuming(singing.energyConsuming()));
                                }
                            }
                        }
                    }
                    if (!lines.isEmpty()) {
                        guiGraphics.renderTooltip(font, lines.stream().map(c -> ComponentHelper.stripStyle((FormattedCharSequence)c.getVisualOrderText())).toList(), mouseX, mouseY);
                    }
                }
            }
        };
    }
}

