/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive;

import com.google.common.collect.Maps;
import dev.wp.industrialization_overdrive.IO;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class IOTags {
    private static final Map<TagKey<Item>, String> TRANSLATIONS = Maps.newHashMap();

    public static TagKey<Item> item(String path, String englishName) {
        TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)IO.id(path));
        TRANSLATIONS.put((TagKey<Item>)tag, englishName);
        return tag;
    }

    public static TagKey<Item> itemCommon(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<Block> block(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)IO.id(path));
    }

    public static TagKey<Block> blockCommon(String path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static final class Items {
        public static final TagKey<Item> MULTI_PROCESSING_ARRAY_BLACKLIST = IOTags.item("multi_processing_array_blacklist", "Multi Processing Array Blacklist");
    }
}

