/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.datagen.client.provider;

import com.google.common.collect.Sets;
import dev.wp.industrialization_overdrive.IOItems;
import java.util.Set;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.tesseract.neoforge.datagen.mi.MIDatagenHooks;
import net.swedz.tesseract.neoforge.lang.LangInstance;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class LanguageDatagenProvider
extends LanguageProvider {
    private static final Set<LangInstance<?>> INSTANCES = Sets.newHashSet();

    public static void include(LangInstance<?> instance) {
        INSTANCES.add(instance);
    }

    public LanguageDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "industrialization_overdrive", "en_us");
    }

    protected void addTranslations() {
        for (LangInstance<?> instance : INSTANCES) {
            instance.datagen((LanguageProvider)this);
        }
        for (ItemHolder item : IOItems.values()) {
            this.add(item.asItem(), item.identifier().englishName());
        }
        MIDatagenHooks.Client.withLanguageHook((LanguageProvider)this, (String)"industrialization_overdrive");
        this.add("itemGroup.%s.%s".formatted("industrialization_overdrive", "industrialization_overdrive"), "Industrialization Overdrive");
        this.add("pyro_tier.%s.%s.%s".formatted("industrialization_overdrive", "modern_industrialization", "cupronickel_coil"), "Cupronickel");
        this.add("pyro_tier.%s.%s.%s".formatted("industrialization_overdrive", "modern_industrialization", "kanthal_coil"), "Kanthal");
        this.add("rei_categories.%s.%s".formatted("industrialization_overdrive", "pyrolyse_oven"), "Pyrolyse Oven");
    }
}

