/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.datagen.server.provider.recipes;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.datagen.server.provider.recipes.RecipesServerDatagenProvider;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.tesseract.neoforge.compat.mi.recipe.MIMachineRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapedRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapelessRecipeBuilder;

public final class MachineItemRecipesServerDatagenProvider
extends RecipesServerDatagenProvider {
    public MachineItemRecipesServerDatagenProvider(GatherDataEvent event) {
        super(event);
    }

    private static String machine(String machine, String tier) {
        return "%s:%s".formatted("industrialization_overdrive", tier == null ? machine : "%s_%s".formatted(tier, machine));
    }

    private static String machineBronze(String machine) {
        return MachineItemRecipesServerDatagenProvider.machine(machine, "bronze");
    }

    private static String machineSteel(String machine) {
        return MachineItemRecipesServerDatagenProvider.machine(machine, "steel");
    }

    private static void addBasicCraftingMachineRecipes(String machineName, String machineTier, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        String recipeId = machineTier == null ? "" : "/%s".formatted(machineTier);
        ShapedRecipeBuilder shapedRecipeBuilder = new ShapedRecipeBuilder();
        crafting.accept(shapedRecipeBuilder);
        shapedRecipeBuilder.output(MachineItemRecipesServerDatagenProvider.machine(machineName, machineTier), 1);
        shapedRecipeBuilder.offerTo(output, IO.id("machines/%s/craft%s".formatted(machineName, recipeId)));
        MIMachineRecipeBuilder.fromShapedToAssembler((ShapedRecipeBuilder)shapedRecipeBuilder).offerTo(output, IO.id("machines/%s/assembler%s".formatted(machineName, recipeId)));
    }

    private static void addBasicCraftingMachineRecipes(String machineName, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machineName, null, crafting, output);
    }

    private static void addBronzeMachineRecipes(String machine, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machine, "bronze", crafting, output);
    }

    private static void addSteelMachineRecipes(String machine, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machine, "steel", crafting, output);
    }

    private static void addElectricMachineRecipes(String machine, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes(machine, "electric", crafting, output);
    }

    private static void addSteelUpgradeMachineRecipes(String machine, RecipeOutput output) {
        ShapelessRecipeBuilder shapelessRecipeBuilder = new ShapelessRecipeBuilder().with(MachineItemRecipesServerDatagenProvider.machineBronze(machine)).with(new ItemLike[]{MIItem.STEEL_UPGRADE}).output(MachineItemRecipesServerDatagenProvider.machineSteel(machine), 1);
        shapelessRecipeBuilder.offerTo(output, IO.id("machines/%s/craft/upgrade_steel".formatted(machine)));
        MIMachineRecipeBuilder.fromShapelessToPacker((ShapelessRecipeBuilder)shapelessRecipeBuilder).offerTo(output, IO.id("machines/%s/packer/upgrade_steel".formatted(machine)));
        MIMachineRecipeBuilder.fromShapelessToUnpackerAndFlip((ShapelessRecipeBuilder)shapelessRecipeBuilder).offerTo(output, IO.id("machines/%s/unpacker/downgrade_steel".formatted(machine)));
    }

    private static void addBronzeAndSteelMachineRecipes(String machine, Consumer<ShapedRecipeBuilder> crafting, RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBronzeMachineRecipes(machine, crafting, output);
        MachineItemRecipesServerDatagenProvider.addSteelUpgradeMachineRecipes(machine, output);
    }

    private static void multiProcessingArray(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("multi_processing_array", builder -> builder.define('A', new ItemLike[]{MIItem.LARGE_ADVANCED_MOTOR}).define('D', new ItemLike[]{MIItem.PROCESSING_UNIT}).define('C', new ItemLike[]{MIMaterials.TITANIUM.getPart((PartKeyProvider)MIParts.MACHINE_CASING_SPECIAL)}).define('S', "modern_industrialization:assembler").pattern("ADA").pattern("CSC").pattern("ADA"), output);
    }

    private static void pyrolyseOven(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.addBasicCraftingMachineRecipes("pyrolyse_oven", builder -> builder.define('H', new ItemLike[]{MIBlock.ADVANCED_MACHINE_HULL}).define('C', new ItemLike[]{MIItem.ELECTRONIC_CIRCUIT}).define('B', new ItemLike[]{MIMaterials.BRONZE.getPart((PartKeyProvider)MIParts.MACHINE_CASING_SPECIAL)}).define('O', "modern_industrialization:coke_oven").define('M', new ItemLike[]{MIMaterials.CUPRONICKEL.getPart((PartKeyProvider)MIParts.WIRE_MAGNETIC)}).pattern("MCM").pattern("OHO").pattern("BCB"), output);
    }

    protected void buildRecipes(RecipeOutput output) {
        MachineItemRecipesServerDatagenProvider.multiProcessingArray(output);
        MachineItemRecipesServerDatagenProvider.pyrolyseOven(output);
    }
}

