/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.mixin;

import java.util.Arrays;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.potionstudios.biomeswevegone.util.GeneratorHeightGetter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ChunkAccess.class})
public abstract class ChunkAccessMixin
implements GeneratorHeightGetter {
    @Unique
    int[] cachedGeneratorHeights = null;

    @Shadow
    public abstract ChunkStatus getPersistedStatus();

    @Shadow
    public abstract int getHeight(Heightmap.Types var1, int var2, int var3);

    @Override
    public int getHeight(ChunkGenerator generator, Heightmap.Types heightmapType, int worldX, int worldZ, RandomState randomState, boolean sampleRaw) {
        int localZ;
        int localX;
        int index;
        if (!sampleRaw && this.getPersistedStatus().isOrAfter(ChunkStatus.NOISE)) {
            return this.getHeight(heightmapType, worldX, worldZ);
        }
        if (this.cachedGeneratorHeights == null) {
            this.cachedGeneratorHeights = new int[256];
            Arrays.fill(this.cachedGeneratorHeights, Integer.MIN_VALUE);
        }
        if (this.cachedGeneratorHeights[index = (localX = worldX & 0xF) + (localZ = worldZ & 0xF) * 16] == Integer.MIN_VALUE) {
            this.cachedGeneratorHeights[index] = generator.getBaseHeight(worldX, worldZ, heightmapType, (LevelHeightAccessor)((ChunkAccess)this), randomState);
        }
        return this.cachedGeneratorHeights[index];
    }
}

