/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.cactus;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.potionstudios.biomeswevegone.world.level.block.plants.cactus.BWGCactusBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.cactus.LiquidType;
import org.jetbrains.annotations.NotNull;

public class CarvedBarrelCactusBlock
extends BWGCactusBlock {
    public static final EnumProperty<LiquidType> LIQUID = EnumProperty.create((String)"liquid", LiquidType.class);

    public CarvedBarrelCactusBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CACTUS).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(LIQUID, (Comparable)((Object)LiquidType.EMPTY)));
    }

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)1.0, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0625, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.0625, (double)0.0625, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return CarvedBarrelCactusBlock.makeShape();
    }

    @Override
    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return CarvedBarrelCactusBlock.makeShape();
    }

    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return CarvedBarrelCactusBlock.makeShape();
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (stack.is(Items.WATER_BUCKET)) {
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(LIQUID, (Comparable)((Object)LiquidType.WATER)));
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(Items.HONEY_BOTTLE)) {
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(LIQUID, (Comparable)((Object)LiquidType.HONEY)));
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(Items.BUCKET) && ((LiquidType)((Object)state.getValue(LIQUID))).equals((Object)LiquidType.WATER)) {
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.WATER_BUCKET));
            level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(LIQUID, (Comparable)((Object)LiquidType.EMPTY)));
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(Items.GLASS_BOTTLE) && ((LiquidType)((Object)state.getValue(LIQUID))).equals((Object)LiquidType.HONEY)) {
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.HONEY_BOTTLE));
            level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(LIQUID, (Comparable)((Object)LiquidType.EMPTY)));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.randomTick(state, level, pos, random);
        if (level.isRainingAt(pos)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(LIQUID, (Comparable)((Object)LiquidType.WATER)));
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
        }
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below());
        return !below.getCollisionShape((BlockGetter)level, pos.below()).getFaceShape(Direction.UP).isEmpty() || below.isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIQUID});
    }
}

