/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.interdimensionalwirelesstransmitter.neoforge.datagen;

import com.refinedmods.refinedstorage.common.support.AbstractActiveColoredDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.direction.DefaultDirectionType;
import com.ultramega.interdimensionalwirelesstransmitter.common.InterdimensionalIdentifierUtil;
import com.ultramega.interdimensionalwirelesstransmitter.common.registry.Blocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStateProviderImpl
extends BlockStateProvider {
    private final ExistingFileHelper existingFileHelper;

    public BlockStateProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "interdimensionalwirelesstransmitter", existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    protected void registerStatesAndModels() {
        ModelFile inactive = this.modelFile(InterdimensionalIdentifierUtil.createInterdimensionalIdentifier("block/interdimensional_wireless_transmitter/inactive"));
        Blocks.INSTANCE.getInterdimensionalWirelessTransmitter().forEach((color, id, block) -> {
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(blockState -> {
                ConfiguredModel.Builder model = ConfiguredModel.builder();
                if (Boolean.TRUE.equals(blockState.getValue((Property)AbstractActiveColoredDirectionalBlock.ACTIVE))) {
                    model.modelFile(this.modelFile(InterdimensionalIdentifierUtil.createInterdimensionalIdentifier("block/interdimensional_wireless_transmitter/" + color.getName())));
                } else {
                    model.modelFile(inactive);
                }
                Direction direction = (Direction)blockState.getValue((Property)DefaultDirectionType.FACE_CLICKED.getProperty());
                this.addRotation(model, direction);
                return model.build();
            });
        });
    }

    private void addRotation(ConfiguredModel.Builder<?> model, Direction direction) {
        int rotationX = direction.getAxis() == Direction.Axis.Y ? (direction == Direction.UP ? 180 : 0) : (direction.getAxis().isHorizontal() ? 90 : 0);
        int rotationY = direction.getAxis().isVertical() ? 0 : (int)direction.toYRot() % 360;
        model.rotationX(rotationX);
        model.rotationY(rotationY);
    }

    private ModelFile modelFile(ResourceLocation location) {
        return new ModelFile.ExistingModelFile(location, this.existingFileHelper);
    }
}

