/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.herbsandharvest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MHHSaplingBlock
extends SaplingBlock
implements BonemealableBlock {
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private final TreeGrower tree;

    public MHHSaplingBlock(TreeGrower tree, BlockBehaviour.Properties properties) {
        super(tree, properties);
        this.tree = tree;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public void performBonemeal(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)STAGE) == 0) {
            world.setBlock(pos, (BlockState)state.cycle((Property)STAGE), 4);
        } else {
            this.tree.growTree(world, world.getChunkSource().getGenerator(), pos, state, rand);
        }
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (double)worldIn.random.nextFloat() < 0.45;
    }

    public void advanceTree(ServerLevel world, BlockPos pos, BlockState state, RandomSource rand) {
        this.performBonemeal(world, rand, pos, state);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAGE});
    }
}

