/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.blocks.furnaces;

import ironfurnaces.blocks.furnaces.BlockIronFurnaceBase;
import ironfurnaces.init.Registration;
import ironfurnaces.tileentity.furnaces.BlockCrystalFurnaceTile;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockCrystalFurnace
extends BlockIronFurnaceBase
implements SimpleWaterloggedBlock {
    public static final String CRYSTAL_FURNACE = "crystal_furnace";
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public BlockCrystalFurnace(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)TYPE, (Comparable)Integer.valueOf(0))).setValue((Property)JOVIAL, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockCrystalFurnace.createFurnaceTicker(level, type, Registration.CRYSTAL_FURNACE_TILE.get());
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = pos.getY();
        double d2 = (double)pos.getZ() + 0.5;
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Direction.Axis direction$axis = direction.getAxis();
        double d3 = 0.52;
        double d4 = rand.nextDouble() * 0.6 - 0.3;
        double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
        double d6 = rand.nextDouble() * 6.0 / 16.0;
        double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
        world.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0 + d5, d1 + d6 - 0.5, d2 + d7, 0.0, 0.0, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0 + d5, d1 + d6 - 0.5, d2 + d7, 0.0, 0.0, 0.0);
        if (world.getBlockEntity(pos) == null) {
            return;
        }
        if (!(world.getBlockEntity(pos) instanceof BlockIronFurnaceTileBase)) {
            return;
        }
        BlockIronFurnaceTileBase tile = (BlockIronFurnaceTileBase)world.getBlockEntity(pos);
        if (tile.getItem(3).getItem() == Registration.SMOKING_AUGMENT.get()) {
            double lvt_5_1_ = (double)pos.getX() + 0.5;
            double lvt_7_1_ = pos.getY();
            double lvt_9_1_ = (double)pos.getZ() + 0.5;
            world.addParticle((ParticleOptions)ParticleTypes.PORTAL, lvt_5_1_, lvt_7_1_ + 1.1, lvt_9_1_, 0.0, 0.0, 0.0);
        }
        super.animateTick(state, world, pos, rand);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{WATERLOGGED}));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new BlockCrystalFurnaceTile(p_153215_, p_153216_);
    }
}

