/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.blocks.furnaces;

import ironfurnaces.Config;
import ironfurnaces.capability.PlayerFurnacesListProvider;
import ironfurnaces.init.Registration;
import ironfurnaces.items.ItemFurnaceCopy;
import ironfurnaces.items.ItemSpooky;
import ironfurnaces.items.ItemXmas;
import ironfurnaces.items.augments.ItemAugment;
import ironfurnaces.items.augments.ItemAugmentGreen;
import ironfurnaces.items.augments.ItemAugmentRed;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import ironfurnaces.tileentity.furnaces.BlockMillionFurnaceTile;
import ironfurnaces.util.DirectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.attachment.AttachmentType;

public abstract class BlockIronFurnaceBase
extends Block
implements EntityBlock {
    public static final IntegerProperty TYPE = IntegerProperty.create((String)"type", (int)0, (int)2);
    public static final IntegerProperty JOVIAL = IntegerProperty.create((String)"jovial", (int)0, (int)2);

    public BlockIronFurnaceBase(BlockBehaviour.Properties properties) {
        super(properties.destroyTime(3.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)TYPE, (Comparable)Integer.valueOf(0))).setValue((Property)JOVIAL, (Comparable)Integer.valueOf(0)));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (((Boolean)Config.disableLightupdates.get()).booleanValue()) {
            return 0;
        }
        return (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 14 : 0;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState p_180633_3_, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            BlockIronFurnaceTileBase te = (BlockIronFurnaceTileBase)world.getBlockEntity(pos);
            Component s = (Component)stack.get(DataComponents.CUSTOM_NAME);
            if (s != null) {
                te.setCustomName(s);
            }
            te.totalCookTime = (Integer)te.getCookTimeConfig().get();
            te.placeConfig();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ((PlayerFurnacesListProvider)player.getData((AttachmentType)((AttachmentType)Registration.PLAYER_FURNACES_LIST.get()))).furnacesList.add(pos);
                if (te instanceof BlockMillionFurnaceTile) {
                    te.owner = player.getUUID();
                }
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult p_225533_6_) {
        ItemStack stack = player.getMainHandItem().copy();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem() instanceof ItemAugment && !player.isCrouching()) {
            return this.interactAugment(world, pos, player);
        }
        if (stack.getItem() instanceof ItemSpooky && !player.isCrouching()) {
            return this.interactJovial(world, pos, player, 1);
        }
        if (stack.getItem() instanceof ItemXmas && !player.isCrouching()) {
            return this.interactJovial(world, pos, player, 2);
        }
        if (stack.isEmpty() && player.isCrouching()) {
            return this.interactJovial(world, pos, player, 0);
        }
        if (stack.getItem() instanceof ItemFurnaceCopy && !player.isCrouching()) {
            return this.interactCopy(world, pos, player);
        }
        return this.interactWith(world, pos, player, state);
    }

    private InteractionResult interactCopy(Level world, BlockPos pos, Player player) {
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof ItemFurnaceCopy)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (!(te instanceof BlockIronFurnaceTileBase)) {
            return InteractionResult.SUCCESS;
        }
        int[] settings = new int[((BlockIronFurnaceTileBase)te).furnaceSettings.size()];
        for (int i = 0; i < ((BlockIronFurnaceTileBase)te).furnaceSettings.size(); ++i) {
            settings[i] = ((BlockIronFurnaceTileBase)te).furnaceSettings.get(i);
        }
        CompoundTag newTag = new CompoundTag();
        newTag.putIntArray("settings", settings);
        newTag.putInt("direction", DirectionUtil.getId((Direction)te.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        stack.set(Registration.FURNACE_SETTINGS.get(), (Object)CustomData.of((CompoundTag)newTag));
        ((BlockIronFurnaceTileBase)te).onUpdateSent();
        player.sendSystemMessage((Component)Component.literal((String)"Settings copied"));
        return InteractionResult.SUCCESS;
    }

    private InteractionResult interactAugment(Level world, BlockPos pos, Player player) {
        int slot;
        ItemStack stack = player.getMainHandItem().copy();
        if (!(stack.getItem() instanceof ItemAugment)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (!(te instanceof BlockIronFurnaceTileBase)) {
            return InteractionResult.SUCCESS;
        }
        int n = stack.getItem() instanceof ItemAugmentRed ? 3 : (slot = stack.getItem() instanceof ItemAugmentGreen ? 4 : 5);
        if (!((WorldlyContainer)te).getItem(slot).isEmpty() && !player.isCreative()) {
            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), ((WorldlyContainer)te).getItem(slot).copyWithCount(1)));
        }
        ItemStack newStack = stack.copyWithCount(1);
        ((WorldlyContainer)te).setItem(slot, newStack);
        world.playSound(null, te.getBlockPos(), SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.05f, 1.0f);
        if (!player.isCreative()) {
            player.getMainHandItem().shrink(1);
        }
        ((BlockIronFurnaceTileBase)te).onUpdateSent();
        te.getLevel().markAndNotifyBlock(pos, player.level().getChunkAt(pos), te.getLevel().getBlockState(pos).getBlock().defaultBlockState(), te.getLevel().getBlockState(pos), 2, 0);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult interactJovial(Level world, BlockPos pos, Player player, int jovial) {
        ItemStack stack = player.getMainHandItem().copy();
        if (!(stack.getItem() instanceof ItemSpooky) && stack.getItem() instanceof ItemXmas && stack.isEmpty()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (!(te instanceof BlockIronFurnaceTileBase)) {
            return InteractionResult.SUCCESS;
        }
        ((BlockIronFurnaceTileBase)te).setJovial(jovial);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult interactWith(Level level, BlockPos pos, Player player, BlockState state) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity be = level.getBlockEntity(pos);
            serverPlayer.openMenu((MenuProvider)be, buf -> buf.writeBlockPos(pos));
            if (be instanceof BlockIronFurnaceTileBase) {
                ((BlockIronFurnaceTileBase)be).furnaceSettings.set(10, 0);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            if (world.getBlockEntity(pos) == null) {
                return;
            }
            if (!(world.getBlockEntity(pos) instanceof BlockIronFurnaceTileBase)) {
                return;
            }
            BlockIronFurnaceTileBase tile = (BlockIronFurnaceTileBase)world.getBlockEntity(pos);
            if (tile.getItem(3).getItem() == Registration.SMOKING_AUGMENT.get()) {
                double lvt_5_1_ = (double)pos.getX() + 0.5;
                double lvt_7_1_ = pos.getY();
                double lvt_9_1_ = (double)pos.getZ() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.playLocalSound(lvt_5_1_, lvt_7_1_, lvt_9_1_, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, lvt_5_1_, lvt_7_1_ + 1.1, lvt_9_1_, 0.0, 0.0, 0.0);
            } else if (tile.getItem(3).getItem() == Registration.BLASTING_AUGMENT.get()) {
                double lvt_5_1_ = (double)pos.getX() + 0.5;
                double lvt_7_1_ = pos.getY();
                double lvt_9_1_ = (double)pos.getZ() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.playLocalSound(lvt_5_1_, lvt_7_1_, lvt_9_1_, SoundEvents.BLASTFURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                Direction lvt_11_1_ = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                Direction.Axis lvt_12_1_ = lvt_11_1_.getAxis();
                double lvt_13_1_ = 0.52;
                double lvt_15_1_ = rand.nextDouble() * 0.6 - 0.3;
                double lvt_17_1_ = lvt_12_1_ == Direction.Axis.X ? (double)lvt_11_1_.getStepX() * 0.52 : lvt_15_1_;
                double lvt_19_1_ = rand.nextDouble() * 9.0 / 16.0;
                double lvt_21_1_ = lvt_12_1_ == Direction.Axis.Z ? (double)lvt_11_1_.getStepZ() * 0.52 : lvt_15_1_;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, lvt_5_1_ + lvt_17_1_, lvt_7_1_ + lvt_19_1_, lvt_9_1_ + lvt_21_1_, 0.0, 0.0, 0.0);
            } else {
                double d0 = (double)pos.getX() + 0.5;
                double d1 = pos.getY();
                double d2 = (double)pos.getZ() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                Direction.Axis direction$axis = direction.getAxis();
                double d3 = 0.52;
                double d4 = rand.nextDouble() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
                double d6 = rand.nextDouble() * 6.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (state.getBlock() != oldState.getBlock()) {
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof BlockIronFurnaceTileBase) {
                BlockIronFurnaceTileBase furnace = (BlockIronFurnaceTileBase)te;
                if (furnace.owner != null && world.getPlayerByUUID(furnace.owner) != null) {
                    ((PlayerFurnacesListProvider)world.getPlayerByUUID((UUID)furnace.owner).getData(Registration.PLAYER_FURNACES_LIST)).furnacesList.remove(te.getBlockPos());
                }
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)furnace);
                furnace.grantStoredRecipeExperience((ServerLevel)world, new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, oldState, p_196243_5_);
        }
    }

    public int getComparatorInputOverride(BlockState state, Level world, BlockPos pos) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (world.getBlockEntity(pos) instanceof BlockIronFurnaceTileBase) {
            int tier;
            BlockIronFurnaceTileBase te = (BlockIronFurnaceTileBase)world.getBlockEntity(pos);
            if (te.isFurnace()) {
                slots.add(0);
            }
            slots.add(1);
            slots.add(2);
            if (te.isGenerator()) {
                slots.add(6);
            }
            if (te.isFactory() && (tier = te.getTier()) >= 0) {
                slots.add(9);
                slots.add(10);
                slots.add(15);
                slots.add(16);
                if (tier >= 1) {
                    slots.add(8);
                    slots.add(11);
                    slots.add(14);
                    slots.add(17);
                    if (tier >= 2) {
                        slots.add(7);
                        slots.add(12);
                        slots.add(13);
                        slots.add(18);
                    }
                }
            }
            return BlockIronFurnaceBase.getRedstoneSignalFromContainer((Container)((WorldlyContainer)world.getBlockEntity(pos)), slots);
        }
        return 0;
    }

    public static int getRedstoneSignalFromContainer(@Nullable Container container, List<Integer> slots) {
        if (container == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int slot : slots) {
            ItemStack itemstack = container.getItem(slot);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(container.getMaxStackSize(), itemstack.getMaxStackSize());
            ++i;
        }
        return Mth.floor((float)((f /= (float)slots.size()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public RenderShape getRenderShape(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)p_185499_2_.rotate((Direction)p_185499_1_.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.rotate(p_185471_2_.getRotation((Direction)p_185471_1_.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    private int calculateOutput(Level worldIn, BlockPos pos, BlockState state) {
        BlockIronFurnaceTileBase tile = (BlockIronFurnaceTileBase)worldIn.getBlockEntity(pos);
        int i = this.getComparatorInputOverride(state, worldIn, pos);
        if (tile != null) {
            int j = tile.furnaceSettings.get(9);
            return tile.furnaceSettings.get(8) == 4 ? Math.max(i - j, 0) : i;
        }
        return 0;
    }

    public boolean isSignalSource(BlockState p_149744_1_) {
        return true;
    }

    public int getSignal(BlockState p_180656_1_, BlockGetter p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        return this.getDirectSignal(p_180656_1_, p_180656_2_, p_180656_3_, p_180656_4_);
    }

    public int getDirectSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction direction) {
        BlockIronFurnaceTileBase furnace;
        if (world.getBlockEntity(pos) instanceof BlockIronFurnaceTileBase && (furnace = (BlockIronFurnaceTileBase)world.getBlockEntity(pos)) != null) {
            int mode = furnace.furnaceSettings.get(8);
            if (mode == 0) {
                return 0;
            }
            if (mode == 1) {
                return 0;
            }
            if (mode == 2) {
                return 0;
            }
            return this.calculateOutput(furnace.getLevel(), pos, blockState);
        }
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.LIT, TYPE, JOVIAL});
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createFurnaceTicker(Level p_151988_, BlockEntityType<T> p_151989_, BlockEntityType<? extends BlockIronFurnaceTileBase> p_151990_) {
        return p_151988_.isClientSide ? null : BlockIronFurnaceBase.createTickerHelper(p_151989_, p_151990_, BlockIronFurnaceTileBase::tick);
    }
}

