/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.tileentity.furnaces;

import ironfurnaces.Config;
import ironfurnaces.container.furnaces.BlockMillionFurnaceContainer;
import ironfurnaces.init.Registration;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ModConfigSpec;

public class BlockMillionFurnaceTile
extends BlockIronFurnaceTileBase {
    public List<BlockIronFurnaceTileBase> furnaces = new ArrayList<BlockIronFurnaceTileBase>();
    public List<BlockPos> furnaces_to_load = new ArrayList<BlockPos>();

    public BlockMillionFurnaceTile(BlockPos pos, BlockState state) {
        super(Registration.MILLION_FURNACE_TILE.get(), pos, state);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CompoundTag furnaces = new CompoundTag();
        for (int i = 0; i < this.furnaces.size(); ++i) {
            CompoundTag tag2 = new CompoundTag();
            tag2.putInt("X", this.furnaces.get(i).getBlockPos().getX());
            tag2.putInt("Y", this.furnaces.get(i).getBlockPos().getY());
            tag2.putInt("Z", this.furnaces.get(i).getBlockPos().getZ());
            furnaces.put("Furnace" + i, (Tag)tag2);
        }
        tag.put("Furnaces", (Tag)furnaces);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        CompoundTag furnaces = tag.getCompound("Furnaces");
        for (int i = 0; i < furnaces.size(); ++i) {
            CompoundTag furnace = furnaces.getCompound("Furnace" + i);
            this.furnaces_to_load.add(new BlockPos(furnace.getInt("X"), furnace.getInt("Y"), furnace.getInt("Z")));
        }
    }

    @Override
    public ModConfigSpec.IntValue getCookTimeConfig() {
        return Config.millionFurnaceSpeed;
    }

    @Override
    public String IgetName() {
        return "container.ironfurnaces.million_furnace";
    }

    @Override
    public AbstractContainerMenu IcreateMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new BlockMillionFurnaceContainer(i, this.level, this.worldPosition, playerInventory, playerEntity);
    }

    @Override
    public int getTier() {
        return (Integer)Config.millionFurnaceTier.get();
    }
}

