/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.collect.ObjectArrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.util.BakedQuadRetextured;

@ParametersAreNonnullByDefault
public class ModelBakedCTM
extends AbstractCTMBakedModel {
    private static final Direction[] FACINGS = (Direction[])ObjectArrays.concat((Object[])Direction.values(), (Object)null);

    public ModelBakedCTM(IModelCTM model, BakedModel parent, @Nullable RenderType layer) {
        super(model, parent, layer);
    }

    @Override
    protected AbstractCTMBakedModel createModel(@Nullable BlockState state, IModelCTM model, BakedModel parent, @Nullable RenderContextList ctx, RandomSource rand, ModelData data, @Nullable RenderType layer) {
        while (parent instanceof ModelBakedCTM) {
            ModelBakedCTM castParent = (ModelBakedCTM)parent;
            parent = castParent.getParent(rand);
        }
        BakedModel finalParent = parent;
        Lazy layerMatches = Lazy.of(() -> {
            if (state == null || finalParent.getRenderTypes(state, rand, data).contains(layer)) {
                return true;
            }
            ItemStack stack = new ItemStack((ItemLike)state.getBlock());
            if (!stack.isEmpty()) {
                return finalParent.getRenderTypes(stack, false).contains(layer) || finalParent.getRenderTypes(stack, true).contains(layer);
            }
            return false;
        });
        ModelBakedCTM ret = new ModelBakedCTM(model, parent, layer);
        for (Direction facing : FACINGS) {
            List parentQuads = parent.getQuads(state, facing, rand, data, null);
            List quads = facing != null ? ret.faceQuads.get((Object)facing) : ret.genQuads;
            LinkedHashMap texturemap = new LinkedHashMap();
            for (BakedQuad q : parentQuads) {
                ICTMTexture<?> tex2 = this.getOverrideTexture(rand, q.getTintIndex(), q.getSprite().contents().name());
                if (tex2 == null) {
                    tex2 = this.getTexture(rand, q.getSprite().contents().name());
                }
                if (tex2 == null) continue;
                TextureAtlasSprite spriteReplacement = this.getOverrideSprite(rand, q.getTintIndex());
                if (spriteReplacement != null) {
                    q = new BakedQuadRetextured(q, spriteReplacement);
                }
                texturemap.put(q, tex2);
            }
            int quadGoal = ctx == null ? 1 : texturemap.values().stream().mapToInt(tex -> tex.getType().getQuadsPerSide()).max().orElse(1);
            for (Map.Entry e : texturemap.entrySet()) {
                ICTMTexture texture = (ICTMTexture)e.getValue();
                if (layer != null && (texture.getLayer() == null || texture.getLayer().getRenderType() != layer) && (texture.getLayer() != null || !((Boolean)layerMatches.get()).booleanValue())) continue;
                ITextureContext tcx = ctx == null ? null : ctx.getRenderContext(texture);
                quads.addAll(texture.transformQuad((BakedQuad)e.getKey(), tcx, quadGoal));
            }
        }
        return ret;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.wrapParticleIcon(super.getParticleIcon());
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrapParticleIcon(super.getParticleIcon(data));
    }

    @NotNull
    private TextureAtlasSprite wrapParticleIcon(@NotNull TextureAtlasSprite particleIcon) {
        return Optional.ofNullable(this.getModel().getTexture(particleIcon.contents().name())).map(ICTMTexture::getParticle).orElse(particleIcon);
    }
}

