/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.newctm;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.Configurations;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.newctm.CTMLogicBakery;
import team.chisel.ctm.client.newctm.ConnectionCheck;
import team.chisel.ctm.client.newctm.ITextureConnection;
import team.chisel.ctm.client.newctm.TextureContextCustomCTM;
import team.chisel.ctm.client.newctm.TextureTypeCustom;
import team.chisel.ctm.client.texture.render.AbstractTexture;
import team.chisel.ctm.client.util.BlockstatePredicateParser;
import team.chisel.ctm.client.util.CTMLogic;
import team.chisel.ctm.client.util.ParseUtils;
import team.chisel.ctm.client.util.PartialTextureAtlasSprite;
import team.chisel.ctm.client.util.Quad;
import team.chisel.ctm.client.util.Submap;

@ParametersAreNonnullByDefault
public class TextureCustomCTM<T extends TextureTypeCustom>
extends AbstractTexture<T>
implements ITextureConnection {
    private static final BlockstatePredicateParser predicateParser = new BlockstatePredicateParser();
    private final Optional<Boolean> connectInside;
    private final boolean ignoreStates;
    @Nullable
    private final BiPredicate<Direction, BlockState> connectionChecks;
    private final TextureAtlasSprite particleSprite;

    public TextureCustomCTM(T type, TextureInfo info) {
        super(type, info);
        this.connectInside = info.getInfo().flatMap(obj -> ParseUtils.getBoolean(obj, "connect_inside"));
        this.ignoreStates = info.getInfo().map(obj -> GsonHelper.getAsBoolean((JsonObject)obj, (String)"ignore_states", (boolean)false)).orElse(false);
        this.connectionChecks = info.getInfo().map(obj -> predicateParser.parse(obj.get("connect_to"))).orElse(null);
        this.particleSprite = PartialTextureAtlasSprite.createPartial(super.getParticle(), this.getFallbackUvs());
    }

    @Override
    public boolean connectTo(ConnectionCheck ctm, BlockState from, BlockState to, Direction dir) {
        try {
            return this.connectionChecks == null ? CTMLogic.StateComparisonCallback.DEFAULT.connects(ctm, from, to, dir) : this.connectionChecks.test(dir, to) && this.connectionChecks.test(dir, from);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TextureAtlasSprite getParticle() {
        return this.particleSprite;
    }

    private ISubmap getFallbackUvs() {
        return this.sprites.length == 1 ? ((TextureTypeCustom)this.type).getFallbackUvs() : Submap.X1;
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad bq, ITextureContext context, int quadGoal) {
        Quad quad = this.makeQuad(bq, context);
        if (context == null || Configurations.isDisabled()) {
            return Collections.singletonList(quad.setUVs(this.sprites[0], this.getFallbackUvs()).rebake());
        }
        CTMLogicBakery.OutputFace[] ctm = ((TextureContextCustomCTM)context).getCTM(bq.getDirection()).getCachedSubmaps();
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        for (CTMLogicBakery.OutputFace face : ctm) {
            Quad sub = quad.subsect(face.face());
            if (sub == null) continue;
            ret.add(sub.setUVs(this.sprites[face.tex()], face.uvs()).rebake());
        }
        return ret;
    }

    @Override
    protected Quad makeQuad(BakedQuad bq, ITextureContext context) {
        return super.makeQuad(bq, context).derotate();
    }

    @Override
    public Optional<Boolean> connectInside() {
        return this.connectInside;
    }

    @Override
    public boolean ignoreStates() {
        return this.ignoreStates;
    }

    private record CacheKey(BlockState from, Direction dir) {
        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dir.hashCode();
            result = 31 * result + System.identityHashCode(this.from);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.dir == other.dir && this.from == other.from;
        }
    }
}

