/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.newctm.json;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.client.util.Submap;

public abstract class MultiSubmap {
    public abstract Iterable<Pair<String, ISubmap>> forName(String var1);

    protected MultiSubmap() {
    }

    public static class Grid
    extends MultiSubmap {
        private final List<Pair<String, ISubmap>> submaps = new ArrayList<Pair<String, ISubmap>>();
        private final int width;
        private final int height;

        protected Grid(int width, int height) {
            this.width = width;
            this.height = height;
            ISubmap[][] grid = Submap.grid(width, height);
            for (int i = 0; i < grid.length; ++i) {
                for (int j = 0; j < grid[i].length; ++j) {
                    this.submaps.add((Pair<String, ISubmap>)Pair.of((Object)(j + "," + i), (Object)grid[i][j]));
                }
            }
        }

        @Override
        public Iterable<Pair<String, ISubmap>> forName(String baseName) {
            return this.submaps.stream().map(p -> Pair.of((Object)(baseName + (String)p.getLeft()), (Object)((ISubmap)p.getRight()))).toList();
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public static class Single
    extends MultiSubmap
    implements ISubmap {
        private final ISubmap submap;

        public Single(float width, float height, float offsetX, float offsetY) {
            this.submap = Submap.fromUnitScale(width, height, offsetX, offsetY);
        }

        @Override
        public Iterable<Pair<String, ISubmap>> forName(String baseName) {
            return List.of(Pair.of((Object)baseName, (Object)this.submap));
        }

        @Override
        public float getYOffset() {
            return this.submap.getYOffset();
        }

        @Override
        public float getXOffset() {
            return this.submap.getXOffset();
        }

        @Override
        public float getWidth() {
            return this.submap.getWidth();
        }

        @Override
        public float getHeight() {
            return this.submap.getHeight();
        }

        @Override
        public float getInterpolatedU(TextureAtlasSprite sprite, float u) {
            return this.submap.getInterpolatedU(sprite, u);
        }

        @Override
        public float getInterpolatedV(TextureAtlasSprite sprite, float v) {
            return this.submap.getInterpolatedV(sprite, v);
        }

        @Override
        public float[] toArray() {
            return this.submap.toArray();
        }

        @Override
        public ISubmap unitScale() {
            return this.submap.unitScale();
        }

        @Override
        public ISubmap pixelScale() {
            return this.submap.pixelScale();
        }

        @Override
        public ISubmap flipX() {
            return this.submap.flipX();
        }

        @Override
        public ISubmap flipY() {
            return this.submap.flipY();
        }
    }
}

