/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.client.newctm.CTMLogicBakery;
import team.chisel.ctm.client.newctm.ConnectionCheck;
import team.chisel.ctm.client.newctm.ICTMLogic;
import team.chisel.ctm.client.newctm.ILogicCache;
import team.chisel.ctm.client.newctm.LocalDirection;
import team.chisel.ctm.client.util.ConnectionLocations;
import team.chisel.ctm.client.util.Dir;
import team.chisel.ctm.client.util.Submap;

@ParametersAreNonnullByDefault
public class CTMLogic
implements ICTMLogic,
ILogicCache {
    public static final ISubmap[] uvs = new ISubmap[]{Submap.fromPixelScale(4.0f, 4.0f, 0.0f, 0.0f), Submap.fromPixelScale(4.0f, 4.0f, 4.0f, 0.0f), Submap.fromPixelScale(4.0f, 4.0f, 8.0f, 0.0f), Submap.fromPixelScale(4.0f, 4.0f, 12.0f, 0.0f), Submap.fromPixelScale(4.0f, 4.0f, 0.0f, 4.0f), Submap.fromPixelScale(4.0f, 4.0f, 4.0f, 4.0f), Submap.fromPixelScale(4.0f, 4.0f, 8.0f, 4.0f), Submap.fromPixelScale(4.0f, 4.0f, 12.0f, 4.0f), Submap.fromPixelScale(4.0f, 4.0f, 0.0f, 8.0f), Submap.fromPixelScale(4.0f, 4.0f, 4.0f, 8.0f), Submap.fromPixelScale(4.0f, 4.0f, 8.0f, 8.0f), Submap.fromPixelScale(4.0f, 4.0f, 12.0f, 8.0f), Submap.fromPixelScale(4.0f, 4.0f, 0.0f, 12.0f), Submap.fromPixelScale(4.0f, 4.0f, 4.0f, 12.0f), Submap.fromPixelScale(4.0f, 4.0f, 8.0f, 12.0f), Submap.fromPixelScale(4.0f, 4.0f, 12.0f, 12.0f), Submap.fromPixelScale(8.0f, 8.0f, 0.0f, 0.0f), Submap.fromPixelScale(8.0f, 8.0f, 8.0f, 0.0f), Submap.fromPixelScale(8.0f, 8.0f, 0.0f, 8.0f), Submap.fromPixelScale(8.0f, 8.0f, 8.0f, 8.0f)};
    public static final ISubmap FULL_TEXTURE = Submap.X1;
    protected static int[] submapOffsets = new int[]{4, 5, 1, 0};
    public ConnectionCheck connectionCheck = new ConnectionCheck();
    protected static final Dir[][] submapMap = new Dir[][]{{Dir.BOTTOM, Dir.LEFT, Dir.BOTTOM_LEFT}, {Dir.BOTTOM, Dir.RIGHT, Dir.BOTTOM_RIGHT}, {Dir.TOP, Dir.RIGHT, Dir.TOP_RIGHT}, {Dir.TOP, Dir.LEFT, Dir.TOP_LEFT}};
    protected byte connectionMap;
    protected int[] submapCache = new int[]{18, 19, 17, 16};

    public static CTMLogic getInstance() {
        return new CTMLogic();
    }

    @Override
    public int[] getSubmapIds(@Nullable BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
        if (world == null) {
            return this.submapCache;
        }
        this.buildConnectionMap(world, pos, state, side);
        for (int i = 0; i < 4; ++i) {
            this.fillSubmaps(i);
        }
        return this.submapCache;
    }

    public int[] createSubmapIndices(long data, Direction side) {
        this.submapCache = new int[]{18, 19, 17, 16};
        this.buildConnectionMap(data, side);
        for (int i = 0; i < 4; ++i) {
            this.fillSubmaps(i);
        }
        return this.submapCache;
    }

    public int[] getSubmapIndices() {
        return this.submapCache;
    }

    @Override
    public long serialized() {
        return Byte.toUnsignedLong(this.connectionMap);
    }

    public static boolean isDefaultTexture(int id) {
        return id == 16 || id == 17 || id == 18 || id == 19;
    }

    protected void setConnectedState(LocalDirection dir, boolean connected) {
        this.connectionMap = CTMLogic.setConnectedState(this.connectionMap, dir, connected);
    }

    private static byte setConnectedState(byte map, LocalDirection dir, boolean connected) {
        if (connected) {
            return (byte)(map | 1 << dir.ordinal());
        }
        return (byte)(map & ~(1 << dir.ordinal()));
    }

    @Override
    public void buildConnectionMap(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
        for (Dir dir : Dir.VALUES) {
            this.setConnectedState(dir, dir.isConnected(this.connectionCheck, world, pos, state, side));
        }
    }

    public void buildConnectionMap(long data, Direction side) {
        this.connectionMap = 0;
        List<ConnectionLocations> connections = ConnectionLocations.decode(data);
        for (ConnectionLocations loc : connections) {
            LocalDirection dir;
            if (loc.getDirForSide(side) == null || (dir = loc.getDirForSide(side)) == null) continue;
            this.setConnectedState(dir, true);
        }
    }

    protected void fillSubmaps(int idx) {
        Dir[] dirs = submapMap[idx];
        if (this.connectedOr(dirs[0], dirs[1])) {
            this.submapCache[idx] = this.connectedAnd(dirs) ? submapOffsets[idx] : submapOffsets[idx] + (this.connected(dirs[0]) ? 2 : 0) + (this.connected(dirs[1]) ? 8 : 0);
        }
    }

    public boolean connected(Dir dir) {
        return (this.connectionMap >> dir.ordinal() & 1) == 1;
    }

    public boolean connectedAnd(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (this.connected(dir)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOr(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (!this.connected(dir)) continue;
            return true;
        }
        return false;
    }

    public boolean connectedNone(Dir ... dirs) {
        for (Dir dir : dirs) {
            if (!this.connected(dir)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOnly(Dir ... dirs) {
        byte map = 0;
        for (Dir dir : dirs) {
            map = CTMLogic.setConnectedState(map, dir, true);
        }
        return map == this.connectionMap;
    }

    public int numConnections() {
        return Integer.bitCount(this.connectionMap);
    }

    @Override
    @Deprecated
    public CTMLogicBakery.OutputFace[] getCachedSubmaps() {
        return new CTMLogicBakery.OutputFace[0];
    }

    @Override
    @Deprecated
    public CTMLogicBakery.OutputFace[] getSubmaps(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
        return new CTMLogicBakery.OutputFace[0];
    }

    @Override
    @Deprecated
    public ILogicCache cached(@Nullable ConnectionCheck connectionCheck) {
        return this;
    }

    @Override
    public List<ISubmap> outputSubmaps() {
        return Arrays.stream(Submap.X2).flatMap(Arrays::stream).toList();
    }

    @Override
    public int requiredTextures() {
        return 2;
    }

    public static interface StateComparisonCallback {
        public static final StateComparisonCallback DEFAULT = (ctm, from, to, dir) -> ctm.ignoreStates() ? from.getBlock() == to.getBlock() : from == to;

        public boolean connects(ConnectionCheck var1, BlockState var2, BlockState var3, Direction var4);
    }
}

