/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct AppOverrideKeys_t")
public class AppOverrideKeys
extends Struct<AppOverrideKeys>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PCHKEY;
    public static final int PCHVALUE;

    protected AppOverrideKeys(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AppOverrideKeys create(long address, @Nullable ByteBuffer container) {
        return new AppOverrideKeys(address, container);
    }

    public AppOverrideKeys(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AppOverrideKeys.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer pchKey() {
        return AppOverrideKeys.npchKey(this.address());
    }

    @NativeType(value="char *")
    public String pchKeyString() {
        return AppOverrideKeys.npchKeyString(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer pchValue(int capacity) {
        return AppOverrideKeys.npchValue(this.address(), capacity);
    }

    public AppOverrideKeys pchKey(@NativeType(value="char *") ByteBuffer value) {
        AppOverrideKeys.npchKey(this.address(), value);
        return this;
    }

    public AppOverrideKeys pchValue(@NativeType(value="char *") ByteBuffer value) {
        AppOverrideKeys.npchValue(this.address(), value);
        return this;
    }

    public AppOverrideKeys set(ByteBuffer pchKey, ByteBuffer pchValue) {
        this.pchKey(pchKey);
        this.pchValue(pchValue);
        return this;
    }

    public AppOverrideKeys set(AppOverrideKeys src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AppOverrideKeys malloc() {
        return new AppOverrideKeys(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AppOverrideKeys calloc() {
        return new AppOverrideKeys(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AppOverrideKeys create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AppOverrideKeys(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AppOverrideKeys create(long address) {
        return new AppOverrideKeys(address, null);
    }

    @Nullable
    public static AppOverrideKeys createSafe(long address) {
        return address == 0L ? null : new AppOverrideKeys(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AppOverrideKeys.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AppOverrideKeys.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AppOverrideKeys mallocStack() {
        return AppOverrideKeys.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AppOverrideKeys callocStack() {
        return AppOverrideKeys.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AppOverrideKeys mallocStack(MemoryStack stack) {
        return AppOverrideKeys.malloc(stack);
    }

    @Deprecated
    public static AppOverrideKeys callocStack(MemoryStack stack) {
        return AppOverrideKeys.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AppOverrideKeys.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AppOverrideKeys.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AppOverrideKeys.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AppOverrideKeys.calloc(capacity, stack);
    }

    public static AppOverrideKeys malloc(MemoryStack stack) {
        return new AppOverrideKeys(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AppOverrideKeys calloc(MemoryStack stack) {
        return new AppOverrideKeys(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npchKey(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHKEY)));
    }

    public static String npchKeyString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHKEY)));
    }

    public static ByteBuffer npchValue(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHVALUE)), (int)capacity);
    }

    public static void npchKey(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PCHKEY), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void npchValue(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCHVALUE), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHKEY)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCHVALUE)));
    }

    static {
        Struct.Layout layout = AppOverrideKeys.__struct((Struct.Member[])new Struct.Member[]{AppOverrideKeys.__member((int)POINTER_SIZE), AppOverrideKeys.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PCHKEY = layout.offsetof(0);
        PCHVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AppOverrideKeys, Buffer>
    implements NativeResource {
        private static final AppOverrideKeys ELEMENT_FACTORY = AppOverrideKeys.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AppOverrideKeys getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char *")
        public ByteBuffer pchKey() {
            return AppOverrideKeys.npchKey(this.address());
        }

        @NativeType(value="char *")
        public String pchKeyString() {
            return AppOverrideKeys.npchKeyString(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer pchValue(int capacity) {
            return AppOverrideKeys.npchValue(this.address(), capacity);
        }

        public Buffer pchKey(@NativeType(value="char *") ByteBuffer value) {
            AppOverrideKeys.npchKey(this.address(), value);
            return this;
        }

        public Buffer pchValue(@NativeType(value="char *") ByteBuffer value) {
            AppOverrideKeys.npchValue(this.address(), value);
            return this;
        }
    }
}

