/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdRect2_t")
public class HmdRect2
extends Struct<HmdRect2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VTOPLEFT;
    public static final int VBOTTOMRIGHT;

    protected HmdRect2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected HmdRect2 create(long address, @Nullable ByteBuffer container) {
        return new HmdRect2(address, container);
    }

    public HmdRect2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), HmdRect2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector2_t")
    public HmdVector2 vTopLeft() {
        return HmdRect2.nvTopLeft(this.address());
    }

    @NativeType(value="HmdVector2_t")
    public HmdVector2 vBottomRight() {
        return HmdRect2.nvBottomRight(this.address());
    }

    public HmdRect2 vTopLeft(@NativeType(value="HmdVector2_t") HmdVector2 value) {
        HmdRect2.nvTopLeft(this.address(), value);
        return this;
    }

    public HmdRect2 vTopLeft(Consumer<HmdVector2> consumer) {
        consumer.accept(this.vTopLeft());
        return this;
    }

    public HmdRect2 vBottomRight(@NativeType(value="HmdVector2_t") HmdVector2 value) {
        HmdRect2.nvBottomRight(this.address(), value);
        return this;
    }

    public HmdRect2 vBottomRight(Consumer<HmdVector2> consumer) {
        consumer.accept(this.vBottomRight());
        return this;
    }

    public HmdRect2 set(HmdVector2 vTopLeft, HmdVector2 vBottomRight) {
        this.vTopLeft(vTopLeft);
        this.vBottomRight(vBottomRight);
        return this;
    }

    public HmdRect2 set(HmdRect2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static HmdRect2 malloc() {
        return new HmdRect2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static HmdRect2 calloc() {
        return new HmdRect2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static HmdRect2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new HmdRect2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static HmdRect2 create(long address) {
        return new HmdRect2(address, null);
    }

    @Nullable
    public static HmdRect2 createSafe(long address) {
        return address == 0L ? null : new HmdRect2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)HmdRect2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdRect2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static HmdRect2 mallocStack() {
        return HmdRect2.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdRect2 callocStack() {
        return HmdRect2.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdRect2 mallocStack(MemoryStack stack) {
        return HmdRect2.malloc(stack);
    }

    @Deprecated
    public static HmdRect2 callocStack(MemoryStack stack) {
        return HmdRect2.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdRect2.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdRect2.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdRect2.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdRect2.calloc(capacity, stack);
    }

    public static HmdRect2 malloc(MemoryStack stack) {
        return new HmdRect2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static HmdRect2 calloc(MemoryStack stack) {
        return new HmdRect2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector2 nvTopLeft(long struct) {
        return HmdVector2.create(struct + (long)VTOPLEFT);
    }

    public static HmdVector2 nvBottomRight(long struct) {
        return HmdVector2.create(struct + (long)VBOTTOMRIGHT);
    }

    public static void nvTopLeft(long struct, HmdVector2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VTOPLEFT), (long)HmdVector2.SIZEOF);
    }

    public static void nvBottomRight(long struct, HmdVector2 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VBOTTOMRIGHT), (long)HmdVector2.SIZEOF);
    }

    static {
        Struct.Layout layout = HmdRect2.__struct((Struct.Member[])new Struct.Member[]{HmdRect2.__member((int)HmdVector2.SIZEOF, (int)HmdVector2.ALIGNOF), HmdRect2.__member((int)HmdVector2.SIZEOF, (int)HmdVector2.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VTOPLEFT = layout.offsetof(0);
        VBOTTOMRIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<HmdRect2, Buffer>
    implements NativeResource {
        private static final HmdRect2 ELEMENT_FACTORY = HmdRect2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected HmdRect2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HmdVector2_t")
        public HmdVector2 vTopLeft() {
            return HmdRect2.nvTopLeft(this.address());
        }

        @NativeType(value="HmdVector2_t")
        public HmdVector2 vBottomRight() {
            return HmdRect2.nvBottomRight(this.address());
        }

        public Buffer vTopLeft(@NativeType(value="HmdVector2_t") HmdVector2 value) {
            HmdRect2.nvTopLeft(this.address(), value);
            return this;
        }

        public Buffer vTopLeft(Consumer<HmdVector2> consumer) {
            consumer.accept(this.vTopLeft());
            return this;
        }

        public Buffer vBottomRight(@NativeType(value="HmdVector2_t") HmdVector2 value) {
            HmdRect2.nvBottomRight(this.address(), value);
            return this;
        }

        public Buffer vBottomRight(Consumer<HmdVector2> consumer) {
            consumer.accept(this.vBottomRight());
            return this;
        }
    }
}

