/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.settings;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.GuiListEditorScreen;
import org.vivecraft.client.gui.framework.screens.GuiOrderedListEditorScreen;
import org.vivecraft.client.gui.framework.screens.GuiSelectionListScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.settings.VRSettings;

public class GuiActiveKeyboardLayoutSelector
extends GuiOrderedListEditorScreen<VRSettings.KeyboardLayout> {
    public GuiActiveKeyboardLayoutSelector(Screen lastScreen) {
        super((Component)Component.translatable((String)"vivecraft.options.screen.activekeyboardlayouts"), lastScreen, false, () -> Arrays.stream(ClientDataHolderVR.getInstance().vrSettings.keyboardLayoutOrder).map(l -> ClientDataHolderVR.getInstance().vrSettings.keyboardLayouts.get(l)).toList(), () -> {
            VRSettings vrSettings = ClientDataHolderVR.getInstance().vrSettings;
            vrSettings.currentKeyboardLayout = 0;
            vrSettings.keyboardLayoutOrder = new String[]{"custom", "en_us"};
            vrSettings.saveOptions();
        }, keyboardLayouts -> {
            VRSettings vrSettings = ClientDataHolderVR.getInstance().vrSettings;
            vrSettings.currentKeyboardLayout = 0;
            vrSettings.keyboardLayoutOrder = (String[])keyboardLayouts.stream().map(VRSettings.KeyboardLayout::id).toArray(String[]::new);
            vrSettings.saveOptions();
        });
    }

    @Override
    public void onClose() {
        super.onClose();
        KeyboardHandler.reinitKeyboard();
    }

    @Override
    protected void addNewValue() {
        this.minecraft.setScreen(GuiActiveKeyboardLayoutSelector.getSelectionScreen(this, layout -> this.elements.stream().noneMatch(e -> e.id().equals(layout.id())), layout -> {
            super.addNewValue();
            this.elements.add(layout);
        }, false));
    }

    @Override
    protected GuiListEditorScreen.ValueEntry<VRSettings.KeyboardLayout> toEntry(VRSettings.KeyboardLayout value, int index) {
        return new KeyboardEntry(this, value, index);
    }

    public static GuiSelectionListScreen<VRSettings.KeyboardLayout> getSelectionScreen(Screen parent, Predicate<VRSettings.KeyboardLayout> filter, Consumer<VRSettings.KeyboardLayout> consumer, boolean hasReset) {
        return new GuiSelectionListScreen<VRSettings.KeyboardLayout>((Component)Component.translatable((String)"vivecraft.options.screen.keyboardlayoutselection"), parent, () -> ClientDataHolderVR.getInstance().vrSettings.keyboardLayouts.values().stream().filter(filter).sorted(Comparator.comparing(key -> GuiActiveKeyboardLayoutSelector.getLangComponent(key).getString())).toList(), GuiActiveKeyboardLayoutSelector::getLangComponent, null, consumer, hasReset, true, null);
    }

    private static Component getLangComponent(VRSettings.KeyboardLayout layout) {
        LanguageInfo info = (LanguageInfo)Minecraft.getInstance().getLanguageManager().getLanguages().get(layout.id());
        return info != null ? info.toComponent() : layout.fallbackName();
    }

    private class KeyboardEntry
    extends GuiOrderedListEditorScreen.OrderedEntry<VRSettings.KeyboardLayout> {
        public KeyboardEntry(GuiActiveKeyboardLayoutSelector guiActiveKeyboardLayoutSelector, VRSettings.KeyboardLayout layout, int index) {
            super(GuiActiveKeyboardLayoutSelector.getLangComponent(layout), layout, index);
        }
    }
}

