/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.s2c;

import net.minecraft.network.FriendlyByteBuf;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;

public record NetworkVersionPayloadS2C(NetworkVersion version) implements VivecraftPayloadS2C
{
    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.NETWORK_VERSION;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.payloadId().ordinal());
        buffer.writeByte(this.version.protocolVersion());
    }

    public static NetworkVersionPayloadS2C read(FriendlyByteBuf buffer) {
        return new NetworkVersionPayloadS2C(NetworkVersion.fromProtocolVersion(buffer.readByte() & 0xFF));
    }
}

