/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.util.UIState;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.model.map.MapState;
import journeymap.client.model.map.MapType;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.draw.OverlayDrawStep;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.MapRenderer;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.ReticleOrientation;
import journeymap.client.ui.minimap.Selectable;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.MapTypeProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class MiniMap
implements Selectable {
    private static final MapState state = new MapState();
    private static final MapRenderer mapRenderer = new MapRenderer(Context.UI.Minimap);
    private final Minecraft mc = Minecraft.getInstance();
    private final WaypointDrawStepFactory waypointRenderer = new WaypointDrawStepFactory();
    private final RadarDrawStepFactory radarRenderer = new RadarDrawStepFactory();
    private DynamicTexture playerArrowFg;
    private DynamicTexture playerArrowBg;
    private int playerArrowColor;
    private MiniMapProperties miniMapProperties;
    private StatTimer drawTimer;
    private StatTimer refreshStateTimer;
    private DisplayVars dv;
    private boolean minimapDragging = false;
    private int mouseDragOffsetX = 0;
    private int mouseDragOffsetY = 0;
    private Point2D.Double centerPoint;
    private Rectangle2D.Double centerRect;
    private long initTime = System.currentTimeMillis();
    private long lastAutoDayNightTime = -1L;
    private Boolean lastPlayerUnderground;
    private boolean drawingInPreviewMode = false;
    private boolean preview = false;

    public MiniMap(MiniMapProperties miniMapProperties) {
        this.setMiniMapProperties(miniMapProperties);
    }

    public static synchronized MapState state() {
        return state;
    }

    public static synchronized UIState uiState() {
        return mapRenderer.getUIState();
    }

    public static void updateUIState(boolean isActive) {
        if (Minecraft.getInstance().level != null) {
            mapRenderer.updateUIState(isActive);
        }
    }

    public DisplayVars getDisplayVars() {
        return this.dv;
    }

    public boolean withinBounds(double mouseX, double mouseY) {
        double scale = JmUI.calculateScaleFactor();
        double posX = mouseX * scale;
        double posY = mouseY * scale;
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        return posX > (double)vars.textureX && posX < (double)(vars.textureX + vars.minimapWidth) && posY > (double)vars.textureY && posY < (double)(vars.textureY + vars.minimapHeight);
    }

    private void initGridRenderer() {
        mapRenderer.clear();
        state.requireRefresh();
        if (this.mc.player == null || !this.mc.player.isAlive()) {
            return;
        }
        int zoom = this.miniMapProperties.zoomLevel.get();
        state.refresh(this.mc, (Player)this.mc.player, this.miniMapProperties);
        MapType mapType = state.getMapType();
        BlockPos playerCamera = this.mc.gameRenderer.getMainCamera().getBlockPosition();
        mapRenderer.setContext(state);
        mapRenderer.center(state.getWorldDir(), mapType, playerCamera.getX(), playerCamera.getZ(), zoom);
        mapRenderer.updateTiles(state.getMapType(), zoom, true);
    }

    public void resetInitTime() {
        this.initTime = System.currentTimeMillis();
    }

    public void setMiniMapProperties(MiniMapProperties miniMapProperties) {
        this.miniMapProperties = miniMapProperties;
        MiniMap.state().requireRefresh();
        this.reset();
    }

    public MiniMapProperties getCurrentMinimapProperties() {
        return this.miniMapProperties;
    }

    public void drawMap(GuiGraphics graphics) {
        this.drawMap(graphics, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMap(GuiGraphics graphics, boolean preview) {
        if (!JourneymapClient.getInstance().getStateHandler().isMinimapEnabled()) {
            return;
        }
        StatTimer timer = this.drawTimer;
        try {
            this.preview = preview;
            graphics.flush();
            MultiBufferSource.BufferSource buffers = graphics.bufferSource();
            graphics.pose().pushPose();
            if (this.mc.player == null || !this.mc.player.isAlive()) {
                return;
            }
            mapRenderer.clearGlErrors(false);
            boolean doStateRefresh = state.shouldRefresh(this.mc, this.miniMapProperties);
            if (doStateRefresh) {
                timer = this.refreshStateTimer.start();
                this.autoDayNight();
                mapRenderer.setContext(state);
                if (!preview) {
                    state.refresh(this.mc, (Player)this.mc.player, this.miniMapProperties);
                }
                ClientAPI.INSTANCE.flagOverlaysForRerender();
            } else {
                timer.start();
            }
            int width = this.mc.getWindow().getScreenWidth();
            int height = this.mc.getWindow().getScreenHeight();
            if (height == 0 || width == 0) {
                return;
            }
            Vec3 playerCamera = this.mc.gameRenderer.getMainCamera().getPosition();
            int zoom = this.miniMapProperties.zoomLevel.get();
            boolean moved = mapRenderer.center(state.getWorldDir(), state.getMapType(), playerCamera.x(), playerCamera.z(), zoom);
            if (moved || doStateRefresh) {
                mapRenderer.updateTiles(state.getMapType(), zoom, doStateRefresh || preview);
            }
            if (doStateRefresh) {
                boolean checkWaypointDistance = JourneymapClient.getInstance().getWaypointProperties().maxDistance.get() > 0;
                state.generateDrawSteps(this.mc, mapRenderer, this.waypointRenderer, this.radarRenderer, this.miniMapProperties, checkWaypointDistance);
                state.updateLastRefresh();
            }
            this.updateDisplayVars(false, preview);
            long now = System.currentTimeMillis();
            DrawUtil.sizeDisplay(width, height);
            RenderWrapper.enableBlend();
            RenderWrapper.blendFunc(770, 0);
            RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderWrapper.enableDepthTest();
            this.dv.minimapFrame.drawMask(graphics, (MultiBufferSource)buffers);
            double rotation = 0.0;
            switch (this.dv.orientation) {
                case North: {
                    rotation = 0.0;
                    break;
                }
                case OldNorth: {
                    rotation = 90.0;
                    break;
                }
                case PlayerHeading: {
                    if (this.dv.shape != Shape.Circle) break;
                    rotation = 180.0f - this.mc.gameRenderer.getMainCamera().getYRot();
                }
            }
            this.startMapRotation(graphics, rotation);
            try {
                Point2D.Double windowCenter;
                float alpha;
                long lastMapChangeTime;
                VertexConsumer vertexBuilder = buffers.getBuffer(JMRenderTypes.RECTANGLE_RENDER_TYPE);
                DrawUtil.drawRectangle(graphics, vertexBuilder, this.dv.textureX, this.dv.textureY, this.dv.minimapWidth, this.dv.minimapHeight, 0x222222, this.miniMapProperties.backgroundAlpha.get().floatValue());
                graphics.pose().translate((float)this.dv.translateX, (float)this.dv.translateY, 0.0f);
                mapRenderer.render(graphics, buffers, 0.0, 0.0, this.dv.terrainAlpha, this.miniMapProperties.showGrid.get());
                this.centerPoint = mapRenderer.getPixel(playerCamera.x(), playerCamera.z());
                this.centerRect = new Rectangle2D.Double(this.centerPoint.x - (double)(this.dv.minimapWidth >> 1), this.centerPoint.y - (double)(this.dv.minimapHeight >> 1), this.dv.minimapWidth, this.dv.minimapHeight);
                this.drawOverlays(graphics, (MultiBufferSource)buffers, rotation);
                graphics.pose().translate((float)(-this.dv.translateX), (float)(-this.dv.translateY), 0.0f);
                ReticleOrientation reticleOrientation = null;
                if (this.dv.showReticle) {
                    reticleOrientation = this.dv.minimapFrame.getReticleOrientation();
                    if (reticleOrientation == ReticleOrientation.Compass) {
                        this.dv.minimapFrame.drawReticle(graphics);
                    } else {
                        this.startMapRotation(graphics, this.mc.gameRenderer.getMainCamera().getYRot());
                        this.dv.minimapFrame.drawReticle(graphics);
                        this.stopMapRotation(graphics, this.mc.gameRenderer.getMainCamera().getYRot());
                    }
                }
                if (now - (lastMapChangeTime = state.getLastMapTypeChange()) <= 1000L) {
                    this.stopMapRotation(graphics, rotation);
                    graphics.pose().translate((float)this.dv.translateX, (float)this.dv.translateY, 0.0f);
                    alpha = (float)Math.min(255L, Math.max(0L, 1100L - (now - lastMapChangeTime))) / 255.0f;
                    windowCenter = mapRenderer.getWindowPosition(this.centerPoint);
                    this.dv.getMapTypeStatus(state.getMapType()).draw(graphics, windowCenter, alpha, 0.0);
                    graphics.pose().translate((float)(-this.dv.translateX), (float)(-this.dv.translateY), 0.0f);
                    this.startMapRotation(graphics, rotation);
                }
                if (now - this.initTime <= 1000L) {
                    this.stopMapRotation(graphics, rotation);
                    graphics.pose().translate((float)this.dv.translateX, (float)this.dv.translateY, 1000.0f);
                    alpha = (float)Math.min(255L, Math.max(0L, 1100L - (now - this.initTime))) / 255.0f;
                    windowCenter = mapRenderer.getWindowPosition(this.centerPoint);
                    this.dv.getMapPresetStatus(state.getMapType(), this.miniMapProperties.getId()).draw(graphics, windowCenter, alpha, 0.0);
                    graphics.pose().translate((float)(-this.dv.translateX), (float)(-this.dv.translateY), -1000.0f);
                    this.startMapRotation(graphics, rotation);
                }
                this.endMasking(graphics);
                if (!this.dv.frameRotates && rotation != 0.0) {
                    this.stopMapRotation(graphics, rotation);
                }
                this.dv.minimapFrame.drawFrame(graphics);
                if (!this.dv.frameRotates && rotation != 0.0) {
                    this.startMapRotation(graphics, rotation);
                }
                if (this.dv.showCompass) {
                    this.dv.minimapCompassPoints.drawPoints(graphics, rotation);
                }
                graphics.pose().translate((float)this.dv.translateX, (float)this.dv.translateY, 0.0f);
                this.drawOnMapEntities(graphics, (MultiBufferSource)buffers, rotation);
                this.drawWaypoints(graphics, buffers, rotation);
                if (this.miniMapProperties.showSelf.get().booleanValue() && this.playerArrowFg != null) {
                    float playerArrowScale = this.miniMapProperties.selfDisplayScale.get().floatValue();
                    if (this.centerPoint != null) {
                        DrawUtil.drawColoredEntity(graphics, this.centerPoint.getX(), this.centerPoint.getY(), this.playerArrowBg, 0xFFFFFF, 1.0f, playerArrowScale / 5.0f, this.mc.gameRenderer.getMainCamera().getYRot());
                        DrawUtil.drawColoredEntity(graphics, this.centerPoint.getX(), this.centerPoint.getY(), this.playerArrowFg, this.playerArrowColor, 1.0f, playerArrowScale / 5.0f, this.mc.gameRenderer.getMainCamera().getYRot());
                    }
                }
                if (this.dv.showCompass) {
                    graphics.pose().translate((float)(-this.dv.translateX), (float)(-this.dv.translateY), 0.0f);
                    this.dv.minimapCompassPoints.drawLabels(graphics, (MultiBufferSource)buffers, rotation);
                }
                graphics.pose().popPose();
                this.dv.drawInfoLabels(graphics, (MultiBufferSource)buffers, now);
            }
            finally {
                this.stopMapRotation(graphics, rotation);
                buffers.endBatch();
            }
            DrawUtil.sizeDisplay((double)this.dv.mainWindow.getWidth() / this.dv.mainWindow.getGuiScale(), (double)this.dv.mainWindow.getHeight() / this.dv.mainWindow.getGuiScale());
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error during MiniMap.drawMap(): " + t.getMessage(), t);
        }
        finally {
            timer.stop();
            mapRenderer.clearGlErrors(true);
        }
    }

    private void drawOnMapEntities(GuiGraphics graphics, MultiBufferSource buffers, double rotation) {
        for (DrawStep.Pass pass : DrawStep.Pass.values()) {
            int zLevel = 0;
            for (DrawStep drawStep : state.getDrawSteps()) {
                if (!(drawStep instanceof DrawEntityStep)) continue;
                DrawEntityStep entityStep = (DrawEntityStep)drawStep;
                Point2D.Double position = entityStep.getPosition(0.0, 0.0, mapRenderer, true);
                boolean onScreen = this.isOnScreen(position, this.centerPoint, this.centerRect);
                if (onScreen) {
                    graphics.pose().pushPose();
                    graphics.pose().translate(0.0f, 0.0f, (float)(++zLevel));
                    drawStep.draw(graphics, buffers, pass, 0.0, 0.0, mapRenderer, this.dv.fontScale, rotation);
                    graphics.pose().popPose();
                    continue;
                }
                Point2D.Double point = this.getPointOnFrame(entityStep.getPosition(0.0, 0.0, mapRenderer, true), this.centerPoint, 8.0);
                entityStep.drawOffscreen(graphics, buffers, pass, point, mapRenderer, rotation);
            }
        }
    }

    private void drawOverlays(GuiGraphics graphics, MultiBufferSource buffers, double rotation) {
        for (DrawStep.Pass pass : DrawStep.Pass.values()) {
            int zLevel = 0;
            for (DrawStep drawStep : state.getDrawSteps()) {
                if (!(drawStep instanceof OverlayDrawStep)) continue;
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, (float)(++zLevel));
                drawStep.draw(graphics, buffers, pass, 0.0, 0.0, mapRenderer, this.dv.fontScale, rotation);
                graphics.pose().popPose();
            }
        }
    }

    private void drawWaypoints(GuiGraphics graphics, MultiBufferSource.BufferSource buffers, double rotation) {
        boolean showLabel = this.miniMapProperties.showWaypointLabels.get();
        for (DrawStep.Pass pass : DrawStep.Pass.values()) {
            for (DrawWayPointStep drawWayPointStep : state.getDrawWaypointSteps()) {
                drawWayPointStep.setIconScale(this.miniMapProperties.waypointIconScale.get().floatValue());
                boolean onScreen = false;
                if (pass == DrawStep.Pass.PreObject || pass == DrawStep.Pass.Object || pass == DrawStep.Pass.PostObject) {
                    Point2D.Double waypointPos = drawWayPointStep.getPosition(0.0, 0.0, mapRenderer, true);
                    onScreen = this.isOnScreen(waypointPos, this.centerPoint, this.centerRect);
                    drawWayPointStep.setOnScreen(onScreen);
                } else {
                    onScreen = drawWayPointStep.isOnScreen();
                }
                if (!JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get().booleanValue() || !JourneymapClient.getInstance().getWaypointProperties().renderWaypointsMap.get().booleanValue()) continue;
                if (onScreen) {
                    drawWayPointStep.setLabelScale(this.miniMapProperties.waypointLabelScale.get().floatValue());
                    drawWayPointStep.setShowLabel(showLabel);
                    drawWayPointStep.draw(graphics, (MultiBufferSource)buffers, pass, 0.0, 0.0, mapRenderer, this.dv.fontScale, rotation);
                    continue;
                }
                Point2D.Double point = this.getPointOnFrame(drawWayPointStep.getPosition(0.0, 0.0, mapRenderer, true), this.centerPoint, 8.0);
                drawWayPointStep.drawOffscreen(graphics, (MultiBufferSource)buffers, DrawStep.Pass.Object, point, rotation);
            }
            buffers.endBatch();
        }
    }

    private void endMasking(GuiGraphics graphics) {
        graphics.bufferSource().endBatch();
        RenderWrapper.clear(256);
    }

    private void startMapRotation(GuiGraphics graphics, double rotation) {
        graphics.pose().pushPose();
        if (rotation % 360.0 != 0.0) {
            double width = (this.dv.displayWidth >> 1) + this.dv.translateX;
            double height = (this.dv.displayHeight >> 1) + this.dv.translateY;
            graphics.pose().translate(width, height, 0.0);
            graphics.pose().mulPose(Axis.ZP.rotationDegrees((float)rotation));
            graphics.pose().translate(-width, -height, 0.0);
        }
        mapRenderer.updateRotation(graphics, rotation);
    }

    private void stopMapRotation(GuiGraphics graphics, double rotation) {
        graphics.pose().popPose();
        mapRenderer.updateRotation(graphics, rotation);
    }

    private boolean isOnScreen(Point2D.Double objectPixel, Point2D centerPixel, Rectangle2D.Double centerRect) {
        if (this.dv.shape == Shape.Circle) {
            return centerPixel.distance(objectPixel) < (double)(this.dv.minimapWidth / 2);
        }
        return centerRect.contains(mapRenderer.getWindowPosition(objectPixel));
    }

    private Point2D.Double getPointOnFrame(Point2D.Double objectPixel, Point2D centerPixel, double offset) {
        if (this.dv.shape == Shape.Circle) {
            Point2D.Double point1 = new Point2D.Double(centerPixel.getX() + offset, centerPixel.getY() + offset);
            double bearing = Math.atan2(objectPixel.getY() - point1.getY(), objectPixel.getX() - point1.getX());
            return new Point2D.Double((double)(this.dv.minimapWidth >> 1) * Math.cos(bearing) + point1.getX(), (double)(this.dv.minimapHeight >> 1) * Math.sin(bearing) + point1.getY());
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(this.dv.textureX - this.dv.translateX, this.dv.textureY - this.dv.translateY, this.dv.minimapWidth, this.dv.minimapHeight);
        if (objectPixel.x > rect.getMaxX()) {
            objectPixel.x = rect.getMaxX() + offset;
        } else if (objectPixel.x < rect.getMinX()) {
            objectPixel.x = rect.getMinX() + offset;
        }
        if (objectPixel.y > rect.getMaxY()) {
            objectPixel.y = rect.getMaxY() + offset;
        } else if (objectPixel.y < rect.getMinY()) {
            objectPixel.y = rect.getMinY() + offset;
        }
        return objectPixel;
    }

    private void autoDayNight() {
        if (this.mc.level != null) {
            EntityDTO player = DataCache.getPlayer();
            boolean any = MapTypeProvider.from(this.getCurrentMinimapProperties().minimapLockedMapType.get()) == MapType.Name.any;
            boolean forceCave = MapTypeProvider.from(this.getCurrentMinimapProperties().minimapLockedMapType.get()) == MapType.Name.underground;
            int forceSlice = this.getCurrentMinimapProperties().caveLayer.get();
            if (any || Level.NETHER == player.dimension && !forceCave) {
                boolean wasInCaves = false;
                if (this.miniMapProperties.showCaves.get().booleanValue() && FeatureManager.getInstance().isAllowed(Feature.MapCaves)) {
                    boolean neverChecked = this.lastPlayerUnderground == null;
                    boolean playerUnderground = player.underground;
                    if (neverChecked || playerUnderground != this.lastPlayerUnderground) {
                        this.lastPlayerUnderground = playerUnderground;
                        if (playerUnderground) {
                            state.setMapType(MapType.underground(player));
                        } else {
                            state.setMapType(MapType.from((MapType.Name)((Object)this.miniMapProperties.preferredMapType.get()), player));
                            wasInCaves = true;
                        }
                    }
                    MapType currentMapType = state.getMapType();
                    if (playerUnderground && currentMapType.isUnderground() && currentMapType.vSlice != player.chunkCoordY) {
                        state.setMapType(MapType.underground(player));
                    }
                }
                if (this.miniMapProperties.showDayNight.get().booleanValue() && (wasInCaves || state.getMapType().isDayOrNight())) {
                    boolean neverChecked;
                    long NIGHT = 13800L;
                    long worldTime = this.mc.level.getDayTime() % 24000L;
                    boolean bl = neverChecked = this.lastAutoDayNightTime == -1L;
                    if (worldTime >= 13800L && (neverChecked || this.lastAutoDayNightTime < 13800L)) {
                        this.lastAutoDayNightTime = worldTime;
                        state.setMapType(MapType.night((ResourceKey<Level>)this.mc.level.dimension()));
                    } else if (worldTime < 13800L && (neverChecked || this.lastAutoDayNightTime >= 13800L)) {
                        this.lastAutoDayNightTime = worldTime;
                        state.setMapType(MapType.day((ResourceKey<Level>)this.mc.level.dimension()));
                    }
                }
            } else if (forceCave && FeatureManager.getInstance().isAllowed(Feature.MapCaves)) {
                state.setMapType(MapType.from(MapType.Name.underground, forceSlice, player.dimension));
            } else if (Level.NETHER != player.dimension) {
                state.setMapType(MapType.from(MapTypeProvider.from(this.getCurrentMinimapProperties().minimapLockedMapType.get()), player));
            }
        }
    }

    public void resetState() {
        if (DataCache.getPlayer().dimension == Level.NETHER) {
            state.setMapType(MapType.underground(DataCache.getPlayer()));
        } else {
            state.setMapType(MapType.day((ResourceKey<Level>)this.mc.level.dimension()));
        }
    }

    public void reset() {
        this.initTime = System.currentTimeMillis();
        this.lastAutoDayNightTime = -1L;
        this.initGridRenderer();
        this.updateDisplayVars((Shape)((Object)this.miniMapProperties.shape.get()), this.miniMapProperties.positionX.get().floatValue(), this.miniMapProperties.positionY.get().floatValue(), (Position)((Object)this.miniMapProperties.position.get()), true, false);
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        this.playerArrowColor = coreProperties.getColor(coreProperties.colorSelf);
        this.playerArrowBg = TextureCache.getTexture(TextureCache.PlayerArrowBG);
        this.playerArrowFg = TextureCache.getTexture(TextureCache.PlayerArrow);
    }

    public void updateDisplayVars(boolean force) {
        this.updateDisplayVars(force, false);
    }

    public void updateDisplayVars(boolean force, boolean preview) {
        if (this.dv != null) {
            this.updateDisplayVars(this.dv.shape, this.dv.positionX, this.dv.positionY, this.dv.position, force, preview);
        }
    }

    public void updateDisplayVars(Shape shape, float posX, float posY, Position position, boolean force, boolean preview) {
        boolean useExisingFrame;
        if (this.dv != null && !force && this.mc.getWindow().getScreenHeight() == this.dv.displayHeight && this.mc.getWindow().getScreenWidth() == this.dv.displayWidth && this.dv.shape == shape && this.dv.positionX == posX && this.dv.positionY == posY && this.dv.position == position && this.dv.fontScale == (double)this.miniMapProperties.fontScale.get().floatValue() && this.dv.infoSlotFontScale == (double)this.miniMapProperties.infoSlotFontScale.get().floatValue()) {
            return;
        }
        if (force) {
            shape = (Shape)((Object)this.miniMapProperties.shape.get());
            posX = this.miniMapProperties.positionX.get().floatValue();
            posY = this.miniMapProperties.positionY.get().floatValue();
            position = (Position)((Object)this.miniMapProperties.position.get());
            state.setForceRefreshState(true);
        }
        this.miniMapProperties.shape.set(shape);
        this.miniMapProperties.positionX.set(Float.valueOf(posX));
        this.miniMapProperties.position.set(position);
        this.miniMapProperties.positionY.set(Float.valueOf(posY));
        this.miniMapProperties.save();
        DisplayVars oldDv = this.dv;
        boolean bl = useExisingFrame = this.dv != null && preview;
        if (this.dv != null && !useExisingFrame && this.dv.minimapFrame != null) {
            this.dv.minimapFrame.clear();
        }
        this.dv = new DisplayVars(this.mc, this.miniMapProperties, useExisingFrame ? this.dv.minimapFrame : null);
        if (oldDv == null || oldDv.shape != this.dv.shape) {
            String timerName = String.format("MiniMap%s.%s", this.miniMapProperties.getId(), shape.name());
            this.drawTimer = StatTimer.get(timerName, 100);
            this.drawTimer.reset();
            this.refreshStateTimer = StatTimer.get(timerName + "+refreshState", 5);
            this.refreshStateTimer.reset();
        }
        double xpad = 0.0;
        double ypad = 0.0;
        Rectangle2D.Double viewPortBounds = new Rectangle2D.Double((double)this.dv.textureX + xpad, (double)this.dv.textureY + ypad, (double)this.dv.minimapWidth - 2.0 * xpad, (double)this.dv.minimapHeight - 2.0 * ypad);
        mapRenderer.setViewPortBounds(viewPortBounds);
        MiniMap.updateUIState(true);
    }

    public String getLocation() {
        int playerX = Mth.floor((double)this.mc.player.getX());
        int playerZ = Mth.floor((double)this.mc.player.getZ());
        int playerY = Mth.floor((double)this.mc.player.getBoundingBox().minY);
        return this.dv.locationFormatKeys.format(this.dv.locationFormatVerbose, playerX, playerZ, playerY, this.mc.player.getBlockY() >> 4);
    }

    public String getBiome() {
        return state.getPlayerBiome();
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.withinBounds(pMouseX, pMouseY) && !this.minimapDragging && this.drawingInPreviewMode) {
            this.minimapDragging = true;
            double scale = JmUI.calculateScaleFactor();
            double posX = pMouseX * scale;
            double posY = pMouseY * scale;
            this.mouseDragOffsetX = (int)(posX - (double)this.getDisplayVars().textureX);
            this.mouseDragOffsetY = (int)(posY - (double)this.getDisplayVars().textureY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.minimapDragging) {
            if (!Position.Custom.equals(this.miniMapProperties.position.get())) {
                this.miniMapProperties.position.set(Position.Custom);
                this.miniMapProperties.position.save();
            }
            int screenHeight = Minecraft.getInstance().getWindow().getScreenHeight();
            int screenWidth = Minecraft.getInstance().getWindow().getScreenWidth();
            Vec2 vec2 = this.validateScreenBounds(pMouseX, pMouseY);
            this.miniMapProperties.positionX.set(Float.valueOf(vec2.x / (float)screenWidth));
            this.miniMapProperties.positionY.set(Float.valueOf(vec2.y / (float)screenHeight));
            this.updateDisplayVars(true, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.minimapDragging) {
            this.mouseDragOffsetX = 0;
            this.mouseDragOffsetY = 0;
            this.minimapDragging = false;
            this.updateDisplayVars(true, true);
            return true;
        }
        return false;
    }

    public boolean isMinimapDragging() {
        return this.minimapDragging;
    }

    @Override
    public void tick() {
        long windowId = Minecraft.getInstance().getWindow().getWindow();
        float speed = JourneymapClient.getInstance().getActiveMiniMapProperties().minimapKeyMovementSpeed.get().floatValue();
        if (InputConstants.isKeyDown((long)windowId, (int)265)) {
            this.moveMiniMapOnKey(0.0f, -speed);
        } else if (InputConstants.isKeyDown((long)windowId, (int)264)) {
            this.moveMiniMapOnKey(0.0f, speed);
        } else if (InputConstants.isKeyDown((long)windowId, (int)263)) {
            this.moveMiniMapOnKey(-speed, 0.0f);
        } else if (InputConstants.isKeyDown((long)windowId, (int)262)) {
            this.moveMiniMapOnKey(speed, 0.0f);
        }
    }

    private void moveMiniMapOnKey(float incX, float incY) {
        float x;
        float pX = this.miniMapProperties.positionX.get().floatValue();
        float pY = this.miniMapProperties.positionY.get().floatValue();
        int screenHeight = Minecraft.getInstance().getWindow().getHeight();
        int screenWidth = Minecraft.getInstance().getWindow().getWidth();
        float texX = (float)screenWidth * (pX + incX);
        float texY = (float)screenHeight * (pY + incY);
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        float f = texX < 0.0f ? 0.0f : (x = texX + (float)vars.minimapWidth > (float)screenWidth ? pX : pX + incX);
        float y = texY < 0.0f ? 0.0f : (texY + (float)vars.minimapHeight > (float)screenHeight ? pY : pY + incY);
        this.miniMapProperties.positionX.set(Float.valueOf(x));
        this.miniMapProperties.positionY.set(Float.valueOf(y));
        this.updateDisplayVars(true, true);
    }

    @Override
    public void renderBorder(GuiGraphics graphics, int color) {
        graphics.pose().pushPose();
        double scale = JmUI.calculateScaleFactor();
        int startX = (int)((double)this.getDisplayVars().textureX / scale);
        int startY = (int)((double)this.getDisplayVars().textureY / scale);
        int width = (int)((double)this.getDisplayVars().minimapWidth / scale);
        int height = (int)((double)this.getDisplayVars().minimapHeight / scale);
        int endX = startX + width;
        int endY = startY + height;
        graphics.fill(startX, startY - 1, endX + 1, startY + 1, color);
        graphics.fill(startX - 1, startY - 1, startX + 1, endY + 2, color);
        graphics.fill(startX, endY, endX + 1, endY + 2, color);
        graphics.fill(endX, startY - 1, endX + 2, endY + 2, color);
        graphics.pose().popPose();
    }

    @Override
    public boolean isDragging() {
        return this.minimapDragging;
    }

    public Vec2 validateScreenBounds(double pMouseX, double pMouseY) {
        float x;
        int screenHeight = Minecraft.getInstance().getWindow().getHeight();
        int screenWidth = Minecraft.getInstance().getWindow().getWidth();
        double scale = JmUI.calculateScaleFactor();
        float posX = (float)(pMouseX * scale - (double)this.mouseDragOffsetX);
        float posY = (float)(pMouseY * scale - (double)this.mouseDragOffsetY);
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        float f = posX < 0.0f ? 0.0f : (x = posX + (float)vars.minimapWidth > (float)screenWidth ? (float)(screenWidth - vars.minimapWidth) : posX);
        float y = posY < 0.0f ? 0.0f : (posY + (float)vars.minimapHeight > (float)screenHeight ? (float)(screenHeight - vars.minimapHeight) : posY);
        return new Vec2(x, y);
    }

    public void setDrawingInPreviewMode(boolean drawingInPreviewMode) {
        this.drawingInPreviewMode = drawingInPreviewMode;
    }

    public boolean isDrawingInPreviewMode() {
        return this.drawingInPreviewMode;
    }
}

