/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.stats;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStat;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;

class VanillaStat
implements SpawnerStat<Integer> {
    private static final Codec<Integer> SHORT_INT = Codec.intRange((int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
    protected final Function<ApothSpawnerTile, Integer> getter;
    protected final BiConsumer<ApothSpawnerTile, Integer> setter;

    VanillaStat(Function<ApothSpawnerTile, Integer> getter, BiConsumer<ApothSpawnerTile, Integer> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public Codec<Integer> getValueCodec() {
        return SHORT_INT;
    }

    @Override
    public Integer getValue(ApothSpawnerTile spawner) {
        return this.getter.apply(spawner);
    }

    @Override
    public void setValue(ApothSpawnerTile spawner, Integer value) {
        this.setter.accept(spawner, value);
    }

    @Override
    public Component getTooltip(ApothSpawnerTile spawner) {
        return SpawnerStat.createTooltip(this, this.getValue(spawner).toString());
    }

    @Override
    public boolean applyModifier(ApothSpawnerTile spawner, Integer value, Optional<Integer> min, Optional<Integer> max) {
        Integer old = this.getValue(spawner);
        this.setValue(spawner, this.clamp(old + value, min, max));
        return old != this.getValue(spawner);
    }

    public String toString() {
        return "SpawnerStat{%s}".formatted(SpawnerStats.REGISTRY.getKey((Object)this));
    }

    private Integer clamp(Integer value, Optional<Integer> min, Optional<Integer> max) {
        if (min.isPresent()) {
            value = Math.max(value, min.get());
        }
        if (max.isPresent()) {
            value = Math.min(value, max.get());
        }
        return value;
    }
}

