/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block.entity;

import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PollinatedLeavesBlockEntity
extends BlockEntity {
    private ItemStack result = ItemStack.EMPTY;
    private Block leafA;
    private Block leafB;

    public PollinatedLeavesBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TreeRegistrator.POLLINATED_LEAVES_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public Block getLeafA() {
        return this.leafA;
    }

    public void setLeafA(Block leaf) {
        this.leafA = leaf;
    }

    public Block getLeafB() {
        return this.leafB;
    }

    public void setLeafB(Block leaf) {
        this.leafB = leaf;
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.loadPacketNBT(pTag, pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        this.savePacketNBT(pTag, pRegistries);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithId(pRegistries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        super.onDataPacket(net, pkt, pRegistries);
        this.loadPacketNBT(pkt.getTag(), pRegistries);
        if (this.level instanceof ClientLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (tag.contains("leafA")) {
            this.leafA = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("leafA")));
        }
        if (tag.contains("leafB")) {
            this.leafB = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("leafB")));
        }
        this.result = tag.contains("result") ? ItemStack.parse((HolderLookup.Provider)pRegistries, (Tag)tag.getCompound("result")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (this.leafA != null) {
            tag.putString("leafA", BuiltInRegistries.BLOCK.getKey((Object)this.leafA).toString());
        }
        if (this.leafB != null) {
            tag.putString("leafB", BuiltInRegistries.BLOCK.getKey((Object)this.leafB).toString());
        }
        if (this.result != null && !this.result.isEmpty()) {
            tag.put("result", this.result.save(pRegistries, (Tag)new CompoundTag()));
        }
    }
}

