/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.inventory;

import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import cy.jdkdigital.productivetrees.common.block.Stripper;
import cy.jdkdigital.productivetrees.common.block.entity.WoodWorkerBlockEntity;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WoodWorkerContainer
extends AbstractContainer {
    public final WoodWorkerBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;

    public WoodWorkerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, WoodWorkerContainer.getTileEntity(playerInventory, data));
    }

    public WoodWorkerContainer(int windowId, Inventory playerInventory, WoodWorkerBlockEntity blockEntity) {
        super((MenuType)TreeRegistrator.STRIPPER_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, WoodWorkerBlockEntity.SLOT_IN, 44, 25));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, WoodWorkerBlockEntity.SLOT_AXE, 44, 44));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, WoodWorkerBlockEntity.SLOT_OUT, 116, 34));
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static WoodWorkerBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof WoodWorkerBlockEntity) {
            return (WoodWorkerBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof Stripper && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

