/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.util.WoodSet;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WoodObject {
    private final ResourceLocation id;
    private final boolean fireProof;
    private final TreeColors colors;
    private final Optional<ResourceLocation> stripDrop;

    public WoodObject(ResourceLocation id, boolean fireProof, TreeColors colors, Optional<ResourceLocation> stripDrop) {
        this.id = id;
        this.fireProof = fireProof;
        this.colors = colors;
        this.stripDrop = stripDrop;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isFireProof() {
        return this.fireProof;
    }

    public WoodSet getStyle() {
        return WoodSet.STYLES.get(this.id.getPath());
    }

    public TreeColors getColors() {
        return this.colors;
    }

    public String getLeafColor() {
        return this.colors.leafColor;
    }

    public String getLogColor() {
        return this.colors.logColor;
    }

    public String getPlankColor() {
        return this.colors.plankColor;
    }

    public Optional<ResourceLocation> getStripDrop() {
        return this.stripDrop;
    }

    public ItemStack getStripDropStack() {
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.stripDrop.get()));
    }

    public record TreeColors(String leafColor, String logColor, String plankColor) {
        static final TreeColors DEFAULT = new TreeColors("#000000", "#000000", "#000000");
        public static Codec<TreeColors> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("leafColor").orElse((Object)"#1d7b00").forGetter(TreeColors::leafColor), (App)Codec.STRING.fieldOf("logColor").orElse((Object)"#917142").forGetter(TreeColors::logColor), (App)Codec.STRING.fieldOf("plankColor").orElse((Object)"#c29d62").forGetter(TreeColors::plankColor)).apply((Applicative)instance, TreeColors::new));
    }
}

