/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.event;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class CompatibilityEventJS
implements KubeEvent {
    private final List<String> messages = new ArrayList<String>();

    public void checkModLoaded(String mod, String reason) {
        if (ModList.get().isLoaded(mod)) {
            this.addIncompatibility("Incompatible mod loaded: " + mod, reason);
        } else {
            KubeJSTweaks.LOGGER.debug("Incompatible mod {} was not loaded.", (Object)mod);
        }
    }

    public void checkModVersion(String mod, String version, String reason) {
        IModFileInfo modFile = ModList.get().getModFileById(mod);
        if (modFile == null) {
            KubeJSTweaks.LOGGER.debug("Mod with id {} was not found!", (Object)mod);
        } else {
            try {
                DefaultArtifactVersion modVer;
                VersionRange versionRange;
                if (!((String)version).contains("[") && !((String)version).contains("]")) {
                    version = "[" + (String)version + "]";
                }
                if ((versionRange = VersionRange.createFromVersionSpec((String)version)).containsVersion((ArtifactVersion)(modVer = new DefaultArtifactVersion(modFile.versionString())))) {
                    KubeJSTweaks.LOGGER.debug("Incompatible mod {} version matches {} with {}", new Object[]{mod, versionRange, modVer});
                    this.addIncompatibility("Incompatible version " + modFile.versionString() + " for mod " + mod, reason);
                }
            }
            catch (InvalidVersionSpecificationException e) {
                KubeJSTweaks.LOGGER.error("Error while checking mod " + mod + " version", (Throwable)e);
            }
        }
    }

    public void addIncompatibility(String message, String reason) {
        this.messages.add(message + "\n - Reason: " + reason);
    }

    @HideFromJS
    public List<String> getMessages() {
        return this.messages;
    }
}

